/*
 * Decompiled with CFR 0.152.
 */
package java_circos;

import gnu.getopt.Getopt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_circos.Chromosome;
import java_circos.ExtensionFileFilter;
import java_circos.Style;
import java_circos.canvas;
import java_circos.circosArc;
import java_circos.circosBridge;
import java_circos.circosCytogenetic;
import java_circos.circosLabel;
import java_circos.circosRing;
import java_circos.circosText;
import java_circos.circosWiggle;
import java_circos.circos_data;
import java_circos.fusion_str;
import java_circos.track_data;
import java_circos.wiggle_structure;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;

public class Java_circos
extends JFrame {
    ArrayList<String> listInputFile = new ArrayList();
    static int textfield_no = 0;
    static TreeMap<String, track_data> input_data = new TreeMap();
    String data_type = "UCSC_bigWig/bedgraph";
    String chrom_filename = "";
    static ArrayList<Chromosome> chromosomeSize = new ArrayList();
    static long whole_genome_nt;
    int radius = 200;
    static double zoomRatio;
    int corner_x = 50;
    int corner_y = 50;
    int WIGGLE_HEIGHT = 20;
    static ArrayList<fusion_str> fusionLoci;
    static ArrayList<wiggle_structure> wiggle_data;
    canvas jPanel1;
    JPanel jPanel2;
    JScrollPane jScrollPane1;
    JComboBox jComboBox1;
    JCheckBox jCheckBox1;
    JCheckBox jCheckBox2;
    JTextField jTextField1;
    JTextField jTextField2;
    JLabel jLabel1;
    JLabel jLabel2;
    JTextArea jTextArea1;
    String data_folder;
    String load_file_folder;
    static boolean logscale;

    public Java_circos(String data_folder, String chrom_filename, int radius, int corner_x, int corner_y) {
        this.data_folder = data_folder;
        this.chrom_filename = chrom_filename;
        this.corner_x = corner_x;
        this.corner_y = corner_y;
        this.load_file_folder = data_folder;
        this.updateScale();
        this.InitComponent();
        boolean seq_no = false;
    }

    private void InitComponent() {
        this.setSize(1000, 500);
        this.setDefaultCloseOperation(3);
        this.jPanel1 = new canvas(this.radius, this.corner_x, this.corner_y);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setPreferredSize(new Dimension(500, 100));
        this.jPanel2 = new JPanel();
        Box hbox1 = Box.createHorizontalBox();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.jPanel1);
        hbox1.add(this.jScrollPane1);
        hbox1.add(this.jPanel2);
        Box vbox1 = Box.createVerticalBox();
        Box hbox12 = Box.createHorizontalBox();
        hbox12.add(new JLabel("Zoom"));
        JButton jButton1 = new JButton("+");
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton1ActionPerformed(evt);
            }
        });
        hbox12.add(Box.createHorizontalStrut(5));
        hbox12.add(jButton1);
        JButton jButton2 = new JButton("-");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton2ActionPerformed(evt);
            }
        });
        hbox12.add(jButton2);
        hbox12.add(Box.createHorizontalStrut(5));
        JButton jButton7 = new JButton("save image");
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton7ActionPerformed(evt);
            }
        });
        hbox12.add(jButton7);
        this.jCheckBox2 = new JCheckBox("high Qty");
        this.jCheckBox2.setSelected(false);
        hbox12.add(this.jCheckBox2);
        vbox1.add(hbox12);
        vbox1.add(Box.createVerticalStrut(15));
        Box hbox11 = Box.createHorizontalBox();
        JLabel jLabel0 = new JLabel("data type");
        hbox11.add(jLabel0);
        hbox11.add(Box.createHorizontalStrut(5));
        String[] combobox1_items = new String[]{"UCSC_bigWig/bedgraph", "UCSC_BigBed/Bed", "Circos_wiggle", "Circos_bridge", "label", "text", "cytogenetic"};
        this.data_type = combobox1_items[0];
        this.jComboBox1 = new JComboBox<String>(new DefaultComboBoxModel<String>(combobox1_items));
        this.jComboBox1.setMaximumSize(this.jComboBox1.getPreferredSize());
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.data_type = (String)Java_circos.this.jComboBox1.getSelectedItem();
                if (Java_circos.this.data_type.equals("Circos_wiggle")) {
                    Java_circos.this.jLabel2.setText("*Color *chrom *start *length *height1 height2 description filled");
                } else if (Java_circos.this.data_type.equals("UCSC_bigWig/bedgraph")) {
                    Java_circos.this.jLabel2.setText("*Color *chrom *start *stop *value");
                    Java_circos.this.jCheckBox1.setEnabled(false);
                } else if (Java_circos.this.data_type.equals("UCSC_BigBed/Bed")) {
                    Java_circos.this.jLabel2.setText("UCSC 3 columns + 9 optional columns");
                } else if (Java_circos.this.data_type.equals("Circos_bridge")) {
                    Java_circos.this.jLabel2.setText("*Color *chrom1 *start1 length1 description1 *chrom2 *start2 length2 description2");
                } else if (Java_circos.this.data_type.equals("ring")) {
                    Java_circos.this.jLabel2.setText("*color *height");
                } else if (Java_circos.this.data_type.equals("arc")) {
                    Java_circos.this.jLabel2.setText("*Color *chrom *start *lenght description");
                } else if (Java_circos.this.data_type.equals("text")) {
                    Java_circos.this.jLabel2.setText("*Color *chrom *start *text *text_type(radio,circumference,normal)");
                } else if (Java_circos.this.data_type.equals("connnection_2_points")) {
                    Java_circos.this.jLabel2.setText("*Color *src_chrom *src_start *des_Radius *des_chrom *des_start");
                } else if (Java_circos.this.data_type.equals("cytogenetic")) {
                    Java_circos.this.jLabel2.setText("*chrom *start *stop *name *gieStain");
                }
            }
        });
        hbox11.add(this.jComboBox1);
        this.jCheckBox1 = new JCheckBox("header");
        this.jCheckBox1.setSelected(true);
        hbox11.add(this.jCheckBox1);
        vbox1.add(hbox11);
        Box hbox15 = Box.createHorizontalBox();
        JButton jButton5 = new JButton("open");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton5ActionPerformed(evt);
            }
        });
        hbox15.add(jButton5);
        this.jTextField2 = new JTextField(8);
        hbox15.add(Box.createHorizontalStrut(5));
        hbox15.add(this.jTextField2);
        vbox1.add(hbox15);
        vbox1.add(Box.createVerticalStrut(2));
        Box hbox16 = Box.createHorizontalBox();
        JButton jButton6 = new JButton("load file");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton6ActionPerformed(evt);
            }
        });
        hbox16.add(jButton6);
        JButton jButton99 = new JButton("refresh");
        jButton99.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton99ActionPerformed(evt);
            }
        });
        hbox16.add(Box.createHorizontalStrut(5));
        hbox16.add(jButton99);
        vbox1.add(hbox16);
        vbox1.add(Box.createVerticalStrut(20));
        Box hbox17 = Box.createHorizontalBox();
        this.jLabel2 = new JLabel("*Color *chrom *start *stop *value");
        hbox17.add(this.jLabel2);
        vbox1.add(hbox17);
        Box hbox171 = Box.createHorizontalBox();
        this.jTextArea1 = new JTextArea(5, 2);
        JScrollPane scrollPane = new JScrollPane(this.jTextArea1, 22, 32);
        hbox171.add(scrollPane);
        vbox1.add(hbox171);
        Box hbox18 = Box.createHorizontalBox();
        JButton jButton999 = new JButton("draw");
        jButton999.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton999ActionPerformed(evt);
            }
        });
        hbox18.add(jButton999);
        JButton jButton9991 = new JButton("undo");
        jButton9991.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton9991ActionPerformed(evt);
            }
        });
        hbox18.add(jButton9991);
        JButton jButton9992 = new JButton("clear");
        jButton9992.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Java_circos.this.jButton9992ActionPerformed(evt);
            }
        });
        hbox18.add(jButton9992);
        vbox1.add(hbox18);
        Box track_des_box = Box.createHorizontalBox();
        this.jLabel1 = new JLabel("<html>tracks<br></html>");
        track_des_box.add(this.jLabel1);
        vbox1.add(track_des_box);
        this.jPanel2.add((Component)vbox1, "Center");
        this.add(hbox1);
        this.jPanel1.setPreferredSize(new Dimension(2 * (this.corner_x + this.radius), 2 * (this.corner_y + this.radius)));
        this.jPanel1.revalidate();
    }

    static ArrayList<wiggle_structure> readInWiggle(String filename) {
        ArrayList<wiggle_structure> result = new ArrayList<wiggle_structure>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            br.readLine();
            int rec_no = 0;
            while ((line = br.readLine()) != null) {
                String[] strarray = line.split("\\s+");
                String chr1 = strarray[0];
                int start = Integer.parseInt(strarray[1]);
                int stop = Integer.parseInt(strarray[2]);
                double value1 = Double.parseDouble(strarray[3]);
                double value2 = Double.parseDouble(strarray[4]);
                if (value1 >= 0.0) {
                    if (value2 < value1) {
                        System.err.println("value2 should larger than value1 when value1 and value2 are positive");
                        System.exit(-1);
                    }
                } else if (value1 < value2) {
                    System.err.println("value1 should larger than value2 when value1 and value2 are negative");
                    System.exit(-1);
                }
                String color = strarray[5];
                result.add(new wiggle_structure(chr1, start, stop, value1, value2, color));
                ++rec_no;
            }
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    static ArrayList<fusion_str> readInFusion(String fileName) {
        ArrayList<fusion_str> result = new ArrayList<fusion_str>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            br.readLine();
            int rec_no = 0;
            while ((line = br.readLine()) != null) {
                String[] strarray = line.split("\\s+");
                String chr1 = strarray[0];
                int start1 = Integer.parseInt(strarray[1]);
                String chr2 = strarray[2];
                int start2 = Integer.parseInt(strarray[3]);
                String description = strarray[4];
                String color = Double.parseDouble(description) > 1.0 ? "255,0,0" : (Double.parseDouble(description) > -1.0 ? "96,96,96" : "0,255,0");
                result.add(new fusion_str(chr1, chr2, start1, start2, description, color));
                ++rec_no;
            }
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        zoomRatio = 2.0 * zoomRatio;
        this.updateScale();
        this.jPanel1.setPreferredSize(new Dimension((int)(2.0 * zoomRatio * (double)(this.corner_x + this.radius)), (int)(2.0 * zoomRatio * (double)(this.corner_y + this.radius))));
        this.jScrollPane1.setViewportView(this.jPanel1);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.updateScale();
        this.jPanel1.setPreferredSize(new Dimension((int)(2.0 * (zoomRatio /= 2.0) * (double)(this.corner_x + this.radius)), (int)(2.0 * zoomRatio * (double)(this.corner_y + this.radius))));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jScrollPane1.revalidate();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Color color = JColorChooser.showDialog(null, "Choose Color", Color.white);
        this.jScrollPane1.setViewportView(this.jPanel1);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.jScrollPane1.setViewportView(this.jPanel1);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser(this.load_file_folder);
        int rVal = c.showOpenDialog(null);
        if (rVal == 0) {
            this.load_file_folder = c.getSelectedFile().getAbsolutePath();
            this.jTextField2.setText(c.getSelectedFile().getAbsolutePath());
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        String filename = this.jTextField2.getText();
        try {
            String track_type = (String)this.jComboBox1.getSelectedItem();
            input_data.put(filename, new track_data(track_type, this.read_input_files(filename)));
            this.listInputFile.add(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.re_setJlabel1();
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    private void re_setJlabel1() {
        String str = "<html>";
        for (String filename1 : this.listInputFile) {
            str = str + filename1 + "<br>";
        }
        str = str + "</html>";
        this.jLabel1.setText(str);
    }

    private float pos2theta(String chr, int pos) {
        long num_nt = 0L;
        boolean found = false;
        for (Chromosome chrom : chromosomeSize) {
            if (chrom.name.equals(chr)) {
                found = true;
                break;
            }
            num_nt += (long)chrom.length;
        }
        if (!found) {
            System.err.println("chrom " + chr + " name was not found");
        }
        return (float)(360.0 - ((double)num_nt + (double)pos) / (double)whole_genome_nt * 360.0);
    }

    private float len2theta(double len) {
        if (len == -1.0) {
            return 360.0f;
        }
        float ret = (float)(len / (double)whole_genome_nt * 360.0);
        return ret;
    }

    double[] get_max_plus_minus(String filename, boolean having_header) throws IOException {
        String line;
        double wiggle_max_plus = 0.0;
        double wiggle_max_minus = 0.0;
        int wiggle_radius = -1;
        String response = JOptionPane.showInputDialog("how long is the radius?");
        wiggle_radius = Integer.parseInt(response);
        BufferedReader br1 = new BufferedReader(new FileReader(filename));
        if (having_header) {
            br1.readLine();
        }
        int rec_no = 0;
        while ((line = br1.readLine()) != null) {
            ++rec_no;
            String[] strarray1 = line.split("\\s+");
            double val = Double.parseDouble(strarray1[3]);
            if (logscale) {
                if (val > 0.0) {
                    if (!(Math.log(val) > wiggle_max_plus)) continue;
                    wiggle_max_plus = Math.log(val);
                    continue;
                }
                if (!(Math.log(-val) > wiggle_max_minus)) continue;
                wiggle_max_minus = Math.log(-val);
                continue;
            }
            if (val > 0.0) {
                if (!(val > wiggle_max_plus)) continue;
                wiggle_max_plus = val;
                continue;
            }
            if (!(val < wiggle_max_minus)) continue;
            wiggle_max_minus = val;
        }
        br1.close();
        double[] ret = new double[]{wiggle_max_plus, wiggle_max_minus, wiggle_radius};
        return ret;
    }

    boolean wiggle_new_pixel(int wiggle_radius, float start, float len, float wiggle_previous_start, int rec_no) {
        double diff_y = (double)wiggle_radius * (Math.sin(start + len) - Math.sin(wiggle_previous_start));
        double diff_x = (double)wiggle_radius * (Math.cos(start + len) - Math.cos(wiggle_previous_start));
        return rec_no > 1 && (diff_y > 1.0 || diff_x > 1.0);
    }

    private int get_chr_no(int interval_no, int[] numInterval_per_chr) {
        for (int i = 0; i < numInterval_per_chr.length; ++i) {
            if ((interval_no -= numInterval_per_chr[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    double get_mean(ArrayList<Double> wig_val) {
        Mean mean = new Mean();
        double[] wig_val_array = new double[wig_val.size()];
        for (int i = 0; i < wig_val_array.length; ++i) {
            wig_val_array[i] = wig_val.get(i);
        }
        return mean.evaluate(wig_val_array);
    }

    double get_max(ArrayList<Double> wig_val) {
        double ret = 0.0;
        double[] wig_val_array = new double[wig_val.size()];
        for (int i = 0; i < wig_val_array.length; ++i) {
            if (!(Math.abs(ret) < Math.abs(wig_val.get(i)))) continue;
            ret = wig_val.get(i);
        }
        return ret;
    }

    private ArrayList<circos_data> UCSC_parse(String filename, BufferedReader br, int wiggle_radius) throws IOException {
        int chr_no;
        ArrayList<Double> wig_val_minus;
        ArrayList<Double> wig_val_plus;
        String[] rgb;
        ArrayList<circos_data> ret = new ArrayList<circos_data>();
        double wiggle_max_plus = 0.0;
        double wiggle_max_minus = 0.0;
        Color color = new Color(0, 0, 0);
        JTextField UCSC_radius = new JTextField("180");
        JTextField UCSC_color = new JTextField("200,100,100");
        Object[] message = new Object[]{"how long is the radius?", UCSC_radius, "wiggle color:", UCSC_color};
        String wiggle_color = "200,100,100";
        int option = JOptionPane.showConfirmDialog(null, message, "Login", 2);
        if (option == 0) {
            wiggle_radius = Integer.parseInt(UCSC_radius.getText());
            wiggle_color = UCSC_color.getText();
            rgb = wiggle_color.split(",");
            if (rgb.length != 3) {
                System.err.println("Color should be RGB format such as 125,125,125");
                System.exit(-1);
            }
        } else {
            return ret;
        }
        color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        double nt_per_pix = Math.max(10.0, (double)whole_genome_nt / (Math.PI * 2 * (double)wiggle_radius));
        float nt_per_pix_theta = this.len2theta(nt_per_pix);
        double[][] UCSC_wiggle_values_plus = new double[chromosomeSize.size()][];
        double[][] UCSC_wiggle_values_minus = new double[chromosomeSize.size()][];
        TreeMap<String, Integer> chrom_idx = new TreeMap<String, Integer>();
        for (int i = 0; i < chromosomeSize.size(); ++i) {
            Chromosome chrom = chromosomeSize.get(i);
            chrom.numInterval = (int)Math.ceil((double)chrom.length / nt_per_pix);
            UCSC_wiggle_values_plus[i] = new double[chrom.numInterval];
            UCSC_wiggle_values_minus[i] = new double[chrom.numInterval];
            chrom_idx.put(chrom.name, i);
        }
        BBFileReader reader = this.readBigFile(filename);
        if (reader != null) {
            BBFileHeader bbFileHdr = reader.getBBFileHeader();
            if (bbFileHdr.isHeaderOK() && bbFileHdr.isBigWig()) {
                for (Chromosome chrom : chromosomeSize) {
                    if (chrom.name.toLowerCase().equals("chrm")) continue;
                    wig_val_plus = new ArrayList();
                    wig_val_minus = new ArrayList();
                    double val = 0.0;
                    String current_chr = chrom.name;
                    int chr_no2 = (Integer)chrom_idx.get(current_chr);
                    int interval_no = 0;
                    int current_chr_stop_base = (int)nt_per_pix;
                    BigWigIterator iter = reader.getBigWigIterator(current_chr, 1, current_chr, chrom.length, true);
                    while (iter.hasNext()) {
                        WigItem f = iter.next();
                        val = f.getWigValue();
                        if (logscale) {
                            val = val > 0.0 ? Math.log(val + 1.0) : -Math.log(-val + 1.0);
                        }
                        int start_chrom = f.getStartBase() + 1;
                        int stop_chrom = f.getEndBase();
                        if (current_chr_stop_base < start_chrom) {
                            UCSC_wiggle_values_plus[chr_no2][interval_no] = this.get_max(wig_val_plus);
                            UCSC_wiggle_values_minus[chr_no2][interval_no] = this.get_max(wig_val_minus);
                            ++interval_no;
                            current_chr_stop_base = (int)((double)current_chr_stop_base + nt_per_pix);
                            wig_val_plus.clear();
                            wig_val_minus.clear();
                            while (current_chr_stop_base < start_chrom) {
                                ++interval_no;
                                current_chr_stop_base = (int)((double)current_chr_stop_base + nt_per_pix);
                            }
                        }
                        if (val > 0.0) {
                            wig_val_plus.add(val);
                        } else {
                            wig_val_minus.add(val);
                        }
                        while (current_chr_stop_base < stop_chrom) {
                            UCSC_wiggle_values_plus[chr_no2][interval_no] = this.get_max(wig_val_plus);
                            UCSC_wiggle_values_minus[chr_no2][interval_no] = this.get_max(wig_val_minus);
                            ++interval_no;
                            current_chr_stop_base = (int)((double)current_chr_stop_base + nt_per_pix);
                            wig_val_plus.clear();
                            wig_val_minus.clear();
                            if (val > 0.0) {
                                wig_val_plus.add(val);
                                continue;
                            }
                            wig_val_minus.add(val);
                        }
                    }
                    if (val > 0.0) {
                        wig_val_plus.add(val);
                    } else {
                        wig_val_minus.add(val);
                    }
                    UCSC_wiggle_values_plus[chr_no2][interval_no] = this.get_max(wig_val_plus);
                    UCSC_wiggle_values_minus[chr_no2][interval_no] = this.get_max(wig_val_minus);
                }
            } else {
                JOptionPane.showMessageDialog(null, "data is not \"" + this.data_type + "\" format");
            }
            reader.close();
        } else {
            String line;
            int interval_no = 0;
            double current_chr_stop_base = nt_per_pix;
            wig_val_plus = new ArrayList<Double>();
            wig_val_minus = new ArrayList<Double>();
            double val = 0.0;
            int chr_no3 = 0;
            int rec_no = 0;
            while ((line = br.readLine()) != null) {
                try {
                    ++rec_no;
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    String[] strarray = line.split("\\s+");
                    String current_chr = strarray[0];
                    if (chrom_idx.get(current_chr) == null) {
                        System.err.println("chromosome " + current_chr + " does not exist");
                        throw new NumberFormatException();
                    }
                    if (strarray.length != 4) {
                        throw new NumberFormatException();
                    }
                    int start_chrom = Integer.parseInt(strarray[1]) + 1;
                    int stop_chrom = Integer.parseInt(strarray[2]);
                    val = Double.parseDouble(strarray[3]);
                    if (logscale) {
                        val = val > 0.0 ? Math.log(val + 1.0) : -Math.log(-val + 1.0);
                    }
                    if (!current_chr.equals(Java_circos.chromosomeSize.get((int)chr_no3).name)) {
                        UCSC_wiggle_values_plus[chr_no3][interval_no] = this.get_max(wig_val_plus);
                        UCSC_wiggle_values_minus[chr_no3][interval_no] = this.get_max(wig_val_minus);
                        chr_no3 = (Integer)chrom_idx.get(current_chr);
                        wig_val_plus.clear();
                        wig_val_minus.clear();
                        current_chr_stop_base = (int)nt_per_pix;
                        interval_no = 0;
                    }
                    if (current_chr_stop_base < (double)start_chrom) {
                        UCSC_wiggle_values_plus[chr_no3][interval_no] = this.get_max(wig_val_plus);
                        UCSC_wiggle_values_minus[chr_no3][interval_no] = this.get_max(wig_val_minus);
                        ++interval_no;
                        current_chr_stop_base += nt_per_pix;
                        wig_val_plus.clear();
                        wig_val_minus.clear();
                        while (current_chr_stop_base < (double)start_chrom) {
                            ++interval_no;
                            current_chr_stop_base += nt_per_pix;
                        }
                    }
                    if (val > 0.0) {
                        wig_val_plus.add(val);
                    } else {
                        wig_val_minus.add(val);
                    }
                    while (current_chr_stop_base < (double)stop_chrom) {
                        UCSC_wiggle_values_plus[chr_no3][interval_no] = this.get_max(wig_val_plus);
                        UCSC_wiggle_values_minus[chr_no3][interval_no] = this.get_max(wig_val_minus);
                        ++interval_no;
                        current_chr_stop_base += nt_per_pix;
                        wig_val_plus.clear();
                        wig_val_minus.clear();
                        if (val > 0.0) {
                            wig_val_plus.add(val);
                            continue;
                        }
                        wig_val_minus.add(val);
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format\nbedgraph format should be like \"chrom,start,stop,value\"");
                    return ret;
                }
            }
            if (val > 0.0) {
                wig_val_plus.add(val);
            } else {
                wig_val_minus.add(val);
            }
            UCSC_wiggle_values_plus[chr_no3][interval_no] = this.get_max(wig_val_plus);
            UCSC_wiggle_values_minus[chr_no3][interval_no] = this.get_max(wig_val_minus);
        }
        for (chr_no = 0; chr_no < UCSC_wiggle_values_plus.length; ++chr_no) {
            for (int interval_no = 0; interval_no < UCSC_wiggle_values_plus[chr_no].length; ++interval_no) {
                if (wiggle_max_plus < UCSC_wiggle_values_plus[chr_no][interval_no]) {
                    wiggle_max_plus = UCSC_wiggle_values_plus[chr_no][interval_no];
                }
                if (!(wiggle_max_minus > UCSC_wiggle_values_minus[chr_no][interval_no])) continue;
                wiggle_max_minus = UCSC_wiggle_values_minus[chr_no][interval_no];
            }
        }
        for (chr_no = 0; chr_no < chromosomeSize.size(); ++chr_no) {
            Chromosome chrom = chromosomeSize.get(chr_no);
            for (int interval_no = 0; interval_no < chrom.numInterval; ++interval_no) {
                int height_minus;
                int expr;
                int height_plus;
                int locus_start = (int)(nt_per_pix * (double)interval_no);
                int locus_stop = locus_start + (int)nt_per_pix;
                if (wiggle_max_plus > 0.0 && (height_plus = (int)(UCSC_wiggle_values_plus[chr_no][interval_no] * (double)this.WIGGLE_HEIGHT / wiggle_max_plus)) > 0) {
                    expr = logscale ? (int)Math.exp(UCSC_wiggle_values_plus[chr_no][interval_no]) - 1 : (int)UCSC_wiggle_values_plus[chr_no][interval_no];
                    ret.add(new circosWiggle(wiggle_radius, color, color, this.pos2theta(chrom.name, locus_start), nt_per_pix_theta, (double)height_plus, locus_start + "-" + locus_stop + " val:" + expr));
                }
                if (!(wiggle_max_minus < 0.0) || (height_minus = (int)(-UCSC_wiggle_values_minus[chr_no][interval_no] * (double)this.WIGGLE_HEIGHT / wiggle_max_minus)) >= 0) continue;
                expr = logscale ? -((int)Math.exp(-UCSC_wiggle_values_minus[chr_no][interval_no])) + 1 : (int)UCSC_wiggle_values_minus[chr_no][interval_no];
                ret.add(new circosWiggle(wiggle_radius, color, color, this.pos2theta(chrom.name, locus_start), nt_per_pix_theta, (double)height_minus, locus_start + "-" + locus_stop + " val:" + expr));
            }
        }
        return ret;
    }

    private ArrayList<ArrayList<circos_data>> bigBed(String filename, int bed_radius, int thickness) {
        ArrayList<ArrayList<circos_data>> ret = new ArrayList<ArrayList<circos_data>>();
        BBFileReader reader = this.readBigFile(filename);
        if (reader != null) {
            BBFileHeader bbFileHdr = reader.getBBFileHeader();
            if (bbFileHdr.isHeaderOK() && bbFileHdr.isBigBed()) {
                for (Chromosome chrom : chromosomeSize) {
                    String current_chr = chrom.name;
                    BigBedIterator iter = reader.getBigBedIterator(current_chr, 1, current_chr, chrom.length, false);
                    while (iter.hasNext()) {
                        BedFeature f = iter.next();
                        String[] otherfields = f.getRestOfFields();
                        String[] strarray = new String[otherfields.length + 3];
                        strarray[0] = current_chr;
                        strarray[1] = Integer.toString(f.getStartBase());
                        strarray[2] = Integer.toString(f.getEndBase());
                        System.arraycopy(otherfields, 0, strarray, 3, otherfields.length);
                        ArrayList<circos_data> one_bed = this.UCSC_bed_parse(strarray, bed_radius, thickness);
                        if (one_bed == null) continue;
                        ret.add(one_bed);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "data is not \"" + this.data_type + "\" format");
            }
            reader.close();
            return ret;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<ArrayList<circos_data>> UCSC_bed(String filename, BufferedReader br) throws IOException {
        ArrayList<ArrayList<circos_data>> ret_bigbed;
        int bed_radius;
        int thickness = 20;
        ArrayList<ArrayList<circos_data>> ret = new ArrayList<ArrayList<circos_data>>();
        String line = br.readLine();
        if (!line.toLowerCase().startsWith("radius")) {
            String response = JOptionPane.showInputDialog("how long is the radius?", (Object)"180");
            if (!this.isInteger(response)) return ret;
            bed_radius = Integer.parseInt(response);
        } else {
            String[] strarray1 = line.split("\\s+");
            bed_radius = Integer.parseInt(strarray1[1]);
        }
        if ((ret_bigbed = this.bigBed(filename, bed_radius, thickness)) != null) {
            return ret_bigbed;
        }
        boolean having_header = this.jCheckBox1.isSelected();
        if (having_header) {
            line = br.readLine();
        }
        int rec_no = 1;
        do {
            String[] strarray;
            if ((strarray = line.split("\\s+")).length < 3) {
                JOptionPane.showMessageDialog(null, "line no " + rec_no + " is not \"" + this.data_type + "\" format");
                return ret;
            }
            try {
                ArrayList<circos_data> one_bed = this.UCSC_bed_parse(strarray, bed_radius, thickness);
                if (one_bed == null) continue;
                ret.add(one_bed);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "line no " + rec_no + " is not \"" + this.data_type + "\" format");
                return ret;
            }
        } while ((line = br.readLine()) != null);
        return ret;
    }

    private ArrayList<circos_data> UCSC_bed_parse(String[] strarray, int bed_radius, int thickness) throws NumberFormatException {
        ArrayList<circos_data> one_bed = new ArrayList<circos_data>();
        String chrom = strarray[0];
        int chromStart = Integer.parseInt(strarray[1]);
        int chromEnd = Integer.parseInt(strarray[2]);
        String name = "";
        int score = 0;
        String strand = "+";
        int thickStart = chromStart;
        int thickEnd = chromEnd;
        Color color = Color.black;
        int blockCount = 0;
        if (strarray.length > 3) {
            name = strarray[3];
            if (strarray.length > 4) {
                score = Integer.parseInt(strarray[4]);
                if (strarray.length > 5 && (strarray[5].equals("+") || strarray[5].equals("-"))) {
                    strand = strarray[5];
                    if (strarray.length > 6 && this.isInteger(strarray[6])) {
                        thickStart = Integer.parseInt(strarray[6]);
                        if (strarray.length > 7 && this.isInteger(strarray[7])) {
                            thickEnd = Integer.parseInt(strarray[7]);
                            if (strarray.length > 8) {
                                String itemRgb = "0,0,0";
                                if (strarray[8].split(",").length == 3) {
                                    itemRgb = strarray[8];
                                }
                                if (strarray.length > 9 && this.isInteger(strarray[9])) {
                                    String[] substrarray;
                                    blockCount = Integer.parseInt(strarray[9]);
                                    if (strarray.length == 12 && (substrarray = strarray[10].split(",")).length == blockCount) {
                                        int i;
                                        int[] blockSizes = new int[blockCount];
                                        for (i = 0; i < substrarray.length; ++i) {
                                            blockSizes[i] = Integer.parseInt(substrarray[i]);
                                        }
                                        substrarray = strarray[11].split(",");
                                        if (substrarray.length == blockCount) {
                                            float len;
                                            int[] blockStarts = new int[blockCount];
                                            for (i = 0; i < blockCount; ++i) {
                                                blockStarts[i] = Integer.parseInt(substrarray[i]);
                                            }
                                            strarray = itemRgb.split(",");
                                            color = strarray.length == 3 ? new Color(Integer.parseInt(strarray[0]), Integer.parseInt(strarray[1]), Integer.parseInt(strarray[2])) : Color.black;
                                            if (thickStart - chromStart > 0) {
                                                float start = this.pos2theta(chrom, chromStart);
                                                len = this.len2theta(thickStart - chromStart);
                                                circosWiggle utr1 = new circosWiggle(bed_radius + thickness / 4, color, color, start, len, (double)(thickness / 2), name);
                                                one_bed.add(utr1);
                                            }
                                            blockStarts[0] = blockStarts[0] + (thickStart - chromStart);
                                            blockSizes[0] = blockSizes[0] - (thickStart - chromStart);
                                            blockSizes[blockStarts.length - 1] = blockSizes[blockStarts.length - 1] - (chromEnd - thickEnd);
                                            for (int i2 = 0; i2 < blockCount; ++i2) {
                                                float start;
                                                if (blockSizes[i2] > 0) {
                                                    start = this.pos2theta(chrom, chromStart + blockStarts[i2]);
                                                    float len2 = this.len2theta(blockSizes[i2]);
                                                    one_bed.add(new circosWiggle(bed_radius, color, color, start, len2, (double)thickness, name));
                                                }
                                                if (i2 >= blockCount - 1) continue;
                                                start = this.pos2theta(chrom, chromStart + blockStarts[i2] + blockSizes[i2]);
                                                float len3 = this.len2theta(blockStarts[i2 + 1] - (blockStarts[i2] + blockSizes[i2]));
                                                one_bed.add(new circosArc(bed_radius + thickness / 2, Color.black, 1, start, len3));
                                            }
                                            if (chromEnd - thickEnd > 0) {
                                                blockStarts[blockStarts.length - 1] = blockStarts[blockStarts.length - 1] + blockSizes[blockStarts.length - 1];
                                                float start = this.pos2theta(chrom, blockStarts[blockStarts.length - 1] + chromStart);
                                                len = this.len2theta(chromEnd - thickEnd);
                                                circosWiggle utr2 = new circosWiggle(bed_radius + thickness / 4, color, color, start, len, (double)(thickness / 2), name);
                                                one_bed.add(utr2);
                                            }
                                            return one_bed;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (thickStart - chromStart > 0) {
            float start = this.pos2theta(chrom, chromStart);
            float len = this.len2theta(thickStart - chromStart);
            circosWiggle utr1 = new circosWiggle(bed_radius + thickness / 4, color, color, start, len, (double)(thickness / 2), name);
            one_bed.add(utr1);
        }
        if (thickEnd - thickStart > 0) {
            float start = this.pos2theta(chrom, thickStart);
            float len = this.len2theta(thickEnd - thickStart);
            one_bed.add(new circosWiggle(bed_radius, color, color, start, len, (double)thickness, name));
        }
        if (chromEnd - thickEnd > 0) {
            float start = this.pos2theta(chrom, thickEnd);
            float len = this.len2theta(chromEnd - thickEnd);
            circosWiggle utr2 = new circosWiggle(bed_radius + thickness / 4, color, color, start, len, (double)(thickness / 2), name);
            one_bed.add(utr2);
        }
        return one_bed;
    }

    private ArrayList<circos_data> read_input_files(String filename) throws FileNotFoundException, IOException {
        boolean having_header;
        ArrayList<circos_data> ret = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        int rec_no = 0;
        int wiggle_radius = 0;
        if (this.data_type.equals("UCSC_bigWig/bedgraph")) {
            ret = this.UCSC_parse(filename, br, wiggle_radius);
            return ret;
        }
        if (this.data_type.equals("UCSC_BigBed/Bed")) {
            ArrayList<ArrayList<circos_data>> beds = this.UCSC_bed(filename, br);
            for (ArrayList<circos_data> cd : beds) {
                ret.addAll(cd);
            }
            return ret;
        }
        if (this.data_type.equals("cytogenetic")) {
            String line;
            String response = JOptionPane.showInputDialog("how long is the radius?", (Object)180);
            wiggle_radius = Integer.parseInt(response);
            br.readLine();
            while ((line = br.readLine()) != null) {
                circosCytogenetic rec;
                block14: {
                    if (line.trim().isEmpty()) continue;
                    ++rec_no;
                    String[] strarray = line.split("\\s+");
                    rec = null;
                    try {
                        if (strarray.length == 5) {
                            String chr = strarray[0];
                            int start = Integer.parseInt(strarray[1]);
                            int stop = Integer.parseInt(strarray[2]);
                            String name = strarray[3];
                            String gieStain = strarray[4];
                            rec = filename.startsWith("textbox") ? new circosCytogenetic(wiggle_radius, chr, start, stop, name, gieStain) : new circosCytogenetic(wiggle_radius, chr, start, stop, name, gieStain);
                            break block14;
                        }
                        throw new Exception();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\"" + " cytogenetic should be format \"chrom chromStart chromEnd name gieStain\"");
                        return ret;
                    }
                }
                if (rec == null) continue;
                ret.add(rec);
            }
            br.close();
            return ret;
        }
        String line = br.readLine();
        ++rec_no;
        if (!line.toLowerCase().startsWith("radius")) {
            circos_data rec;
            String response = JOptionPane.showInputDialog("how long is the radius?", (Object)"180");
            if (!this.isInteger(response)) {
                return ret;
            }
            wiggle_radius = Integer.parseInt(response);
            having_header = this.jCheckBox1.isSelected();
            if (!having_header && (rec = this.circus_parse(rec_no, line, wiggle_radius)) != null) {
                ret.add(rec);
            }
        } else {
            String[] strarray1 = line.split("\\s+");
            wiggle_radius = Integer.parseInt(strarray1[1]);
            having_header = this.jCheckBox1.isSelected();
            if (having_header) {
                br.readLine();
                ++rec_no;
            }
        }
        while ((line = br.readLine()) != null) {
            circos_data rec;
            if (line.isEmpty()) continue;
            if ((rec = this.circus_parse(++rec_no, line, wiggle_radius)) == null) break;
            ret.add(rec);
        }
        br.close();
        System.out.println("finish reading data in");
        return ret;
    }

    private circos_data circus_parse(int rec_no, String line, int circos_radius) {
        Color c;
        String[] rgb;
        circos_data rec;
        String[] strarray;
        block63: {
            block62: {
                String chr;
                block61: {
                    strarray = line.split("\\s+");
                    rec = null;
                    if (this.data_type.equals("Circos_wiggle")) {
                        block60: {
                            try {
                                String des;
                                double height1;
                                double height;
                                float len;
                                float start;
                                Color color;
                                if (strarray.length == 5) {
                                    rgb = strarray[0].split(",");
                                    if (rgb.length != 3) {
                                        System.err.println("Color should be RGB format such as 125,125,125");
                                        System.exit(-1);
                                    }
                                    color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                    chr = strarray[1];
                                    start = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                                    len = this.len2theta(Integer.parseInt(strarray[3]));
                                    height = Double.parseDouble(strarray[4]);
                                    rec = new circosWiggle(circos_radius, color, Color.black, start, len, height);
                                    break block60;
                                }
                                if (strarray.length == 6) {
                                    rgb = strarray[0].split(",");
                                    if (rgb.length != 3) {
                                        System.err.println("Color should be RGB format such as 125,125,125");
                                        System.exit(-1);
                                    }
                                    color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                    chr = strarray[1];
                                    start = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                                    len = this.len2theta(Integer.parseInt(strarray[3]));
                                    height = Double.parseDouble(strarray[4]);
                                    String des2 = strarray[5];
                                    rec = new circosWiggle(circos_radius, color, Color.black, start, len, height, des2);
                                    break block60;
                                }
                                if (strarray.length == 7) {
                                    rgb = strarray[0].split(",");
                                    if (rgb.length != 3) {
                                        System.err.println("Color should be RGB format such as 125,125,125");
                                        System.exit(-1);
                                    }
                                    color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                    chr = strarray[1];
                                    start = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                                    len = this.len2theta(Integer.parseInt(strarray[3]));
                                    height1 = Double.parseDouble(strarray[4]);
                                    double height2 = Double.parseDouble(strarray[5]);
                                    des = strarray[6];
                                    rec = new circosWiggle(circos_radius, color, start, len, height1, height2, des);
                                    break block60;
                                }
                                if (strarray.length == 8) {
                                    rgb = strarray[0].split(",");
                                    if (rgb.length != 3) {
                                        System.err.println("Color should be RGB format such as 125,125,125");
                                        System.exit(-1);
                                    }
                                    color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                    chr = strarray[1];
                                    start = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                                    len = this.len2theta(Integer.parseInt(strarray[3]));
                                    height1 = Double.parseDouble(strarray[4]);
                                    double height2 = Double.parseDouble(strarray[5]);
                                    des = strarray[6];
                                    boolean filled = Boolean.parseBoolean(strarray[7]);
                                    rec = new circosWiggle(circos_radius, color, start, len, height1, height2, des, filled);
                                    break block60;
                                }
                                throw new NumberFormatException();
                            }
                            catch (NumberFormatException e) {
                                JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format\njcircos wiggle format should be like \"Color,chrom,start,len,height1,height2,descript,fill\"");
                                return rec;
                            }
                        }
                        circosWiggle tmp_rec = (circosWiggle)rec;
                        if (tmp_rec.height1 == 0.0 && tmp_rec.height2 == 0.0) {
                            return rec;
                        }
                        if (tmp_rec.range.arcAngle == 0.0f) {
                            return rec;
                        }
                    }
                    if (this.data_type.equals("Circos_bridge")) {
                        try {
                            float start1;
                            String chr1;
                            if (strarray.length == 4) {
                                String[] rgb2;
                                String[] strarray1 = new String[5];
                                if (strarray[0].startsWith("chr")) {
                                    strarray1[4] = strarray[3];
                                    strarray1[3] = strarray[2];
                                    strarray1[2] = strarray[1];
                                    strarray1[1] = strarray[0];
                                    strarray1[0] = "0,0,0";
                                }
                                if ((rgb2 = strarray1[0].split(",")).length != 3) {
                                    System.err.println("Color should be RGB format such as 125,125,125");
                                    System.err.println(line);
                                    throw new Exception();
                                }
                                Color c2 = new Color(Integer.parseInt(rgb2[0]), Integer.parseInt(rgb2[1]), Integer.parseInt(rgb2[2]));
                                String chr12 = strarray1[1];
                                float start12 = this.pos2theta(chr12, Integer.parseInt(strarray1[2]));
                                String chr2 = strarray1[3];
                                float start2 = this.pos2theta(chr2, Integer.parseInt(strarray1[4]));
                                rec = start2 < start12 ? new circosBridge(circos_radius, c2, start2, start12) : new circosBridge(circos_radius, c2, start12, start2);
                                break block61;
                            }
                            if (strarray.length == 5) {
                                if (strarray[0].startsWith("chr")) {
                                    double FC = Double.parseDouble(strarray[4]);
                                    strarray[4] = strarray[3];
                                    strarray[3] = strarray[2];
                                    strarray[2] = strarray[1];
                                    strarray[1] = strarray[0];
                                    strarray[0] = FC > 0.0 ? "255,0,0" : (FC < 0.0 ? "0,255,0" : "0,0,0");
                                }
                                if ((rgb = strarray[0].split(",")).length != 3) {
                                    System.err.println("Color should be RGB format such as 125,125,125");
                                    System.err.println(line);
                                    throw new Exception();
                                }
                                c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                chr1 = strarray[1];
                                start1 = this.pos2theta(chr1, Integer.parseInt(strarray[2]));
                                String chr2 = strarray[3];
                                float start2 = this.pos2theta(chr2, Integer.parseInt(strarray[4]));
                                rec = start2 < start1 ? new circosBridge(circos_radius, c, start2, start1) : new circosBridge(circos_radius, c, start1, start2);
                                break block61;
                            }
                            if (strarray.length == 7) {
                                rgb = strarray[0].split(",");
                                if (rgb.length != 3) {
                                    System.err.println("Color should be RGB format such as 125,125,125");
                                    throw new NumberFormatException();
                                }
                                c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                chr1 = strarray[1];
                                start1 = this.pos2theta(chr1, Integer.parseInt(strarray[2]));
                                String des1 = strarray[3];
                                String chr2 = strarray[4];
                                float start2 = this.pos2theta(chr2, Integer.parseInt(strarray[5]));
                                String des2 = strarray[6];
                                rec = start2 < start1 ? new circosBridge(circos_radius, c, start2, des2, start1, des1) : new circosBridge(circos_radius, c, start1, des1, start2, des2);
                                break block61;
                            }
                            if (strarray.length == 9) {
                                rgb = strarray[0].split(",");
                                if (rgb.length != 3) {
                                    System.err.println("Color should be RGB format such as 125,125,125");
                                    throw new Exception();
                                }
                                c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                                chr1 = strarray[1];
                                start1 = this.pos2theta(chr1, Integer.parseInt(strarray[2]));
                                float len1 = this.len2theta(Integer.parseInt(strarray[3]));
                                String des1 = strarray[4];
                                String chr2 = strarray[5];
                                float start2 = this.pos2theta(chr2, Integer.parseInt(strarray[6]));
                                float len2 = this.len2theta(Integer.parseInt(strarray[7]));
                                String des2 = strarray[8];
                                rec = start2 < start1 ? new circosBridge(circos_radius, c, start2, len2, des2, start1, len1, des1) : new circosBridge(circos_radius, c, start1, len1, des1, start2, len2, des2);
                                break block61;
                            }
                            System.err.println("wiggle file do not has 6,8,10 columns (" + strarray.length + ") in line " + rec_no);
                            throw new NumberFormatException();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format");
                            return rec;
                        }
                    }
                }
                if (this.data_type.equals("arc")) {
                    try {
                        float start;
                        float len;
                        if (strarray.length == 4) {
                            rgb = strarray[0].split(",");
                            if (rgb.length != 3) {
                                System.err.println("Color should be RGB format such as 125,125,125");
                                throw new Exception();
                            }
                            c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            chr = strarray[1];
                            float start2 = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                            len = this.len2theta(Integer.parseInt(strarray[3]));
                            rec = new circosArc(circos_radius, c, 1, start2, len);
                            break block62;
                        }
                        if (strarray.length == 5) {
                            rgb = strarray[0].split(",");
                            if (rgb.length != 3) {
                                System.err.println("Color should be RGB format such as 125,125,125");
                                throw new Exception();
                            }
                            c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            if (this.isInteger(strarray[1])) {
                                int height = Integer.parseInt(strarray[1]);
                                String chr2 = strarray[2];
                                start = this.pos2theta(chr2, Integer.parseInt(strarray[3]));
                                float len2 = this.len2theta(Integer.parseInt(strarray[4]));
                                rec = new circosArc(circos_radius, c, height, start, len2);
                            } else {
                                chr = strarray[1];
                                float start3 = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                                len = this.len2theta(Integer.parseInt(strarray[3]));
                                String des = strarray[4];
                                rec = new circosArc(circos_radius, c, 1, start3, len, des);
                            }
                            break block62;
                        }
                        if (strarray.length == 6) {
                            rgb = strarray[0].split(",");
                            if (rgb.length != 3) {
                                System.err.println("Color should be RGB format such as 125,125,125");
                                throw new Exception();
                            }
                            c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                            int height = Integer.parseInt(strarray[1]);
                            String chr3 = strarray[2];
                            start = this.pos2theta(chr3, Integer.parseInt(strarray[3]));
                            float len3 = this.len2theta(Integer.parseInt(strarray[4]));
                            String des = strarray[5];
                            rec = new circosArc(circos_radius, c, height, start, len3, des);
                            break block62;
                        }
                        System.err.println("arc file do not has 5, 6 columns (" + strarray.length + ") in line " + rec_no);
                        throw new Exception();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format");
                    }
                }
            }
            if (this.data_type.equals("ring")) {
                try {
                    if (strarray.length == 2) {
                        rgb = strarray[0].split(",");
                        if (rgb.length != 3) {
                            System.err.println("Color should be RGB format such as 125,125,125");
                            throw new Exception();
                        }
                        c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                        int height = Integer.parseInt(strarray[1]);
                        rec = new circosRing(circos_radius, c, height);
                    } else {
                        System.err.println("ring file do not has 2 columns (" + strarray.length + ") in line " + rec_no);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format");
                }
            }
            if (this.data_type.equals("text")) {
                try {
                    if (strarray.length == 5) {
                        rgb = strarray[0].split(",");
                        if (rgb.length != 3) {
                            System.err.println("Color should be RGB format such as 125,125,125");
                            System.exit(-1);
                        }
                        c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                        String chr = strarray[1];
                        float start = this.pos2theta(chr, Integer.parseInt(strarray[2]));
                        String str = strarray[3];
                        String style = strarray[4];
                        if (style.equals("normal")) {
                            rec = new circosText(circos_radius, c, start, str, Style.NORAML);
                        } else if (style.equalsIgnoreCase("radio")) {
                            rec = new circosText(circos_radius, c, start, str, Style.EMMISION);
                        } else if (style.equalsIgnoreCase("circumference")) {
                            rec = new circosText(circos_radius, c, start, str, Style.CURVE);
                        } else {
                            System.err.println("text style is not exist (" + style + ")");
                        }
                        break block63;
                    }
                    System.err.println("arc file do not has 5, 6 columns (" + strarray.length + ") in line " + rec_no);
                    throw new Exception();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format");
                }
            }
        }
        if (this.data_type.equals("label")) {
            try {
                if (strarray.length == 7) {
                    rgb = strarray[0].split(",");
                    if (rgb.length != 3) {
                        System.err.println("Color should be RGB format such as 125,125,125");
                        System.exit(-1);
                    }
                } else {
                    System.err.println("arc file do not has 7 columns (" + strarray.length + ") in line " + rec_no);
                    throw new Exception();
                }
                c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                String chr1 = strarray[1];
                float src_start = this.pos2theta(chr1, Integer.parseInt(strarray[2]));
                int des_Radius = Integer.parseInt(strarray[3]);
                String chr2 = strarray[4];
                float des_start = this.pos2theta(chr2, Integer.parseInt(strarray[5]));
                String label = strarray[6];
                rec = new circosLabel(circos_radius, c, src_start, des_start, des_Radius, label);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "line no:" + rec_no + " is not \"" + this.data_type + "\" format");
            }
        }
        return rec;
    }

    private BBFileReader readBigFile(String filename) {
        try {
            return new BBFileReader(filename);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void jButton99ActionPerformed(ActionEvent evt) {
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    private void jButton999ActionPerformed(ActionEvent evt) {
        if (this.jTextArea1.getText().isEmpty()) {
            return;
        }
        try {
            String filename = "textbox_" + textfield_no + ".dat";
            ++textfield_no;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(filename));){
                String[] strarray;
                String line = this.jTextArea1.getText();
                for (String strarray1 : strarray = line.split("\n")) {
                    bw.write(strarray1 + "\n");
                }
            }
            this.data_type = (String)this.jComboBox1.getSelectedItem();
            input_data.put(filename, new track_data(this.data_type, this.read_input_files(filename)));
            this.listInputFile.add(filename);
            this.re_setJlabel1();
            this.jPanel1.revalidate();
            this.jPanel1.repaint();
            this.jTextArea1.setText("");
        }
        catch (IOException ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton9991ActionPerformed(ActionEvent evt) {
        if (this.listInputFile.size() > 0) {
            input_data.remove(this.listInputFile.get(this.listInputFile.size() - 1));
            this.listInputFile.remove(this.listInputFile.size() - 1);
            this.re_setJlabel1();
            this.jPanel1.revalidate();
            this.jPanel1.repaint();
        }
    }

    private void jButton9992ActionPerformed(ActionEvent evt) {
        this.jTextArea1.setText("");
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter filter = new ExtensionFileFilter("eps", new String[]{"EPS"});
        fc.addChoosableFileFilter(filter);
        fc.setCurrentDirectory(new File("."));
        fc.setToolTipText("extension:eps");
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                double ratio = this.jCheckBox2.isSelected() ? 20.0 : 5.0;
                this.jPanel1.save_high_vector_image(file.getAbsolutePath() + ".eps", ratio / zoomRatio);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void updateScale() {
        whole_genome_nt = this.readInChromosomeSize();
    }

    private long readInChromosomeSize() {
        chromosomeSize.clear();
        long whole_nt_length = 0L;
        try {
            String line;
            if (new File(this.data_folder + "/" + this.chrom_filename).exists()) {
                this.data_folder = this.data_folder + "/";
            } else {
                System.err.println(this.data_folder + "/" + this.chrom_filename + " is not exist");
                System.exit(-1);
            }
            BufferedReader br = new BufferedReader(new FileReader(this.data_folder + this.chrom_filename));
            int maxLen = 0;
            while ((line = br.readLine()) != null) {
                String[] strarray = line.split("\t");
                if (strarray.length != 2) continue;
                int len = Integer.parseInt(strarray[1]);
                if (maxLen < len) {
                    maxLen = len;
                }
                chromosomeSize.add(new Chromosome(strarray[0], Integer.parseInt(strarray[1]), -1));
                whole_nt_length += (long)Integer.parseInt(strarray[1]);
            }
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(canvas.class.getName()).log(Level.SEVERE, null, ex);
        }
        return whole_nt_length;
    }

    private String transfer_file(String local_path, String filename) {
        try {
            int bytesRead;
            int blockSize = 81920;
            byte[] buffer = new byte[blockSize];
            URL url = new URL("http://data.australianprostatecentre.org/RNAseq/J-Circos/Data/" + filename);
            BufferedInputStream inputStream = null;
            BufferedOutputStream outputStream = null;
            URLConnection connection = url.openConnection();
            double fileSize = (double)connection.getContentLength() / (double)blockSize;
            inputStream = new BufferedInputStream(connection.getInputStream(), blockSize);
            File f = new File(local_path + "/" + filename);
            double finished_size = 0.0;
            outputStream = new BufferedOutputStream(new FileOutputStream(f));
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                finished_size += (double)bytesRead / (double)blockSize;
            }
            inputStream.close();
            outputStream.close();
            System.out.println(filename + " transfered successfully");
            return "success";
        }
        catch (IOException ex) {
            System.err.println(ex.toString());
            System.out.println(filename + " did not transfered successfully");
            return "failure";
        }
    }

    public static void main(String[] args) {
        int c;
        int Radius = 200;
        int Corner_x = 50;
        int Corner_y = 50;
        Getopt g = new Getopt("J_Circos", args, "r:c:l:");
        block8: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 114: {
                    Radius = Integer.parseInt(g.getOptarg());
                    continue block8;
                }
                case 99: {
                    String[] strarray = g.getOptarg().split(",");
                    Corner_x = Integer.parseInt(strarray[0]);
                    Corner_y = Integer.parseInt(strarray[1]);
                    continue block8;
                }
                case 108: {
                    if (!g.getOptarg().toLowerCase().equals("false")) continue block8;
                    logscale = false;
                    continue block8;
                }
                case 104: {
                    Java_circos.print_usage();
                    System.exit(1);
                }
            }
            Java_circos.print_usage();
            System.exit(1);
        }
        if (args.length != g.getOptind() + 1) {
            Java_circos.print_usage();
            System.exit(1);
        }
        String chromosome_filename = args[g.getOptind()];
        try {
            Java_circos frame = new Java_circos("Data/", chromosome_filename, Radius, Corner_x, Corner_y);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static void print_usage() {
        System.out.println("Usage: -r filename (chromosome size)");
        System.out.println("-r: Radius (default 200)");
        System.out.println("-c: left-upper corner coordinate (x,y) (default 50,50)");
    }

    static {
        zoomRatio = 1.0;
        logscale = true;
    }
}

