/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.samtools.seekablestream.SeekableFTPStream;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;

public class SeekableStreamFactory {
    public static SeekableStream getStreamFor(URL url) throws IOException {
        return SeekableStreamFactory.getStreamFor(url.toExternalForm());
    }

    public static boolean isFilePath(String path) {
        return !path.startsWith("http:") && !path.startsWith("https:") && !path.startsWith("ftp:");
    }

    public static SeekableStream getStreamFor(String path) throws IOException {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            URL url = new URL(path);
            return new SeekableHTTPStream(url);
        }
        if (path.startsWith("ftp:")) {
            return new SeekableFTPStream(new URL(path));
        }
        return new SeekableFileStream(new File(path));
    }
}

