/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.Range;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.StringUtil;

class QseqParser
implements IlluminaParser<QseqReadData> {
    private final int[] outputLengths;
    private final QseqReadParser[] parsers;
    private final List<IlluminaFileMap> tileMapByReadNumber;
    private QseqReadData nextData;
    public static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.Position, IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.PF}));

    public QseqParser(int lane, List<IlluminaFileMap> tileMapByReadNumber, OutputMapping outputMapping) {
        this.outputLengths = outputMapping.getOutputReadLengths();
        this.tileMapByReadNumber = tileMapByReadNumber;
        List<QseqReadParser> parsersList = this.makeReadParserList(lane, outputMapping);
        this.parsers = parsersList.toArray(new QseqReadParser[parsersList.size()]);
        this.retrieveNext();
    }

    public List<QseqReadParser> makeReadParserList(int lane, OutputMapping outputMapping) {
        int[] actualReadLengths = new int[this.tileMapByReadNumber.size()];
        int availableCycles = 0;
        for (int i = 0; i < actualReadLengths.length; ++i) {
            actualReadLengths[i] = QseqReadParser.getReadLength((File)this.tileMapByReadNumber.get(i).firstEntry().getValue());
            availableCycles += actualReadLengths[i];
        }
        if (availableCycles < outputMapping.getTotalOutputCycles()) {
            throw new PicardException("Expected output cycles (" + outputMapping.getTotalOutputCycles() + ") is greater than the number of cycles in Qseq files (" + availableCycles + ")");
        }
        ArrayList<QseqReadParser> parsersList = new ArrayList<QseqReadParser>(actualReadLengths.length);
        List<Range> splitOutputRanges = QseqParser.splitOutputRangesOnQseqBoundaries(actualReadLengths, outputMapping);
        List<List<Range>> inputRangesPerRead = QseqParser.outputRangesToInputRanges(actualReadLengths, splitOutputRanges);
        ArrayList<Integer> outputRangesPerRead = new ArrayList<Integer>(inputRangesPerRead.size());
        for (List<Range> readRange : inputRangesPerRead) {
            outputRangesPerRead.add(readRange.size());
        }
        List<List<OutputMapping.TwoDIndex>> outputTargets = QseqParser.outputRangesTo2DTargetsPerRead(outputRangesPerRead, splitOutputRanges, outputMapping);
        for (int i = 0; i < inputRangesPerRead.size(); ++i) {
            if ((Integer)outputRangesPerRead.get(i) <= 0) continue;
            List<Range> inputRanges = inputRangesPerRead.get(i);
            List<OutputMapping.TwoDIndex> outputTarget = outputTargets.get(i);
            parsersList.add(new QseqReadParser(lane, this.tileMapByReadNumber.get(i), inputRanges.toArray(new Range[inputRanges.size()]), outputTarget.toArray(new OutputMapping.TwoDIndex[outputTarget.size()]), outputMapping));
        }
        if (parsersList.size() == 0) {
            throw new PicardException("0 Qseq \"ends\" were found to parse!");
        }
        return parsersList;
    }

    public static List<List<Range>> outputRangesToInputRanges(int[] readLengths, List<Range> outputRanges) {
        ArrayList<Range> scratchOutputRanges = new ArrayList<Range>(outputRanges);
        ArrayList<List<Range>> readRanges = new ArrayList<List<Range>>(readLengths.length);
        for (int i = 0; i < readLengths.length; ++i) {
            readRanges.add(new LinkedList());
        }
        int currentRead = 0;
        int startingCycle = 0;
        int endCycle = readLengths[startingCycle] - 1;
        List currentReadList = (List)readRanges.get(currentRead);
        while (!scratchOutputRanges.isEmpty()) {
            int outRangeEnd;
            Range range = (Range)scratchOutputRanges.remove(0);
            while (range.start > endCycle) {
                startingCycle = endCycle + 1;
                endCycle = startingCycle + readLengths[++currentRead] - 1;
                currentReadList = (List)readRanges.get(currentRead);
            }
            if (endCycle < range.end) {
                scratchOutputRanges.add(0, new Range(endCycle + 1, range.end));
                outRangeEnd = endCycle;
            } else {
                outRangeEnd = range.end;
            }
            currentReadList.add(new Range(range.start - startingCycle, outRangeEnd - startingCycle));
        }
        return readRanges;
    }

    public static List<List<OutputMapping.TwoDIndex>> outputRangesTo2DTargetsPerRead(List<Integer> rangesPerRead, List<Range> splitOutputRanges, OutputMapping outputMapping) {
        ArrayList<List<OutputMapping.TwoDIndex>> outputTargets = new ArrayList<List<OutputMapping.TwoDIndex>>(rangesPerRead.size());
        for (int i = 0; i < rangesPerRead.size(); ++i) {
            outputTargets.add(new ArrayList(rangesPerRead.get(i)));
        }
        int count = 0;
        int readIndex = 0;
        int numRangesForRead = rangesPerRead.get(readIndex);
        List currentReadTargets = (List)outputTargets.get(readIndex);
        for (Range or : splitOutputRanges) {
            while (count >= numRangesForRead) {
                count = 0;
                numRangesForRead = rangesPerRead.get(++readIndex);
                currentReadTargets = (List)outputTargets.get(readIndex);
            }
            currentReadTargets.add(outputMapping.getOutputIndexForCycle(or.start + 1));
            ++count;
        }
        return outputTargets;
    }

    public static List<Range> splitOutputRangesOnQseqBoundaries(int[] qseqReadLengths, OutputMapping outputMapping) {
        LinkedList<Range> outputCycleIndexRanges = new LinkedList<Range>(Arrays.asList(outputMapping.getCycleIndexRanges()));
        LinkedList<Range> outputRanges = new LinkedList<Range>();
        int qseqArray = 0;
        int startCycleIndex = 0;
        while (outputCycleIndexRanges.size() > 0) {
            Range curRange = (Range)outputCycleIndexRanges.remove(0);
            int endCycleIndex = startCycleIndex + qseqReadLengths[qseqArray] - 1;
            if (curRange.start <= endCycleIndex) {
                if (curRange.end > endCycleIndex) {
                    outputRanges.add(new Range(curRange.start, endCycleIndex));
                    outputCycleIndexRanges.add(0, new Range(endCycleIndex + 1, curRange.end));
                    continue;
                }
                outputRanges.add(curRange);
                continue;
            }
            outputCycleIndexRanges.add(0, curRange);
            startCycleIndex = endCycleIndex + 1;
            ++qseqArray;
        }
        return outputRanges;
    }

    @Override
    public void verifyData(List<Integer> tiles, int[] cycles) {
        Integer numTiles = null;
        int end = 1;
        for (IlluminaFileMap tilesToFiles : this.tileMapByReadNumber) {
            if (tiles != null && !tilesToFiles.keySet().containsAll(tiles)) {
                TreeSet<Integer> missingTiles = new TreeSet<Integer>(tiles);
                missingTiles.removeAll(tilesToFiles.keySet());
                throw new PicardException("IlluminaFileMap for \"end\" number " + end + " is missing tiles: " + StringUtil.join((String)",", new ArrayList<Integer>(missingTiles)));
            }
            if (numTiles == null) {
                numTiles = tilesToFiles.size();
            } else if (numTiles.intValue() != tilesToFiles.size()) {
                throw new PicardException("Qseq \"end\" files do not have the same number of tiles expected(" + numTiles + ") found(" + tilesToFiles.size() + ") on end (" + end + ")");
            }
            Integer numBases = null;
            for (Map.Entry tileNoToFile : tilesToFiles.entrySet()) {
                int readLength = QseqReadParser.getReadLength((File)tileNoToFile.getValue());
                if (numBases == null) {
                    numBases = readLength;
                    continue;
                }
                if (numBases == readLength) continue;
                throw new PicardException("Qseq \"end\" (" + end + ") has tiles with different numbers of bases per read.  Found on Tile(" + tileNoToFile.getKey() + ") File(" + ((File)tileNoToFile.getValue()).getAbsolutePath() + ")");
            }
            ++end;
        }
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        for (QseqReadParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
        this.retrieveNext();
    }

    @Override
    public QseqReadData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QseqReadData currentData = this.nextData;
        this.retrieveNext();
        return currentData;
    }

    private void retrieveNext() {
        if (this.parsers[0].hasNext()) {
            this.nextData = new QseqReadData(this.outputLengths);
            for (QseqReadParser parser : this.parsers) {
                parser.next(this.nextData);
            }
        } else {
            this.nextData = null;
        }
    }

    @Override
    public int getTileOfNextCluster() {
        return this.nextData.getTile();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + QseqParser.class.getName());
    }

    @Override
    public boolean hasNext() {
        return this.nextData != null;
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }
}

