/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.PerTileParser;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import net.sf.picard.illumina.parser.readers.ClocsFileReader;
import net.sf.picard.illumina.parser.readers.LocsFileReader;
import net.sf.picard.illumina.parser.readers.PosFileReader;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CollectionUtil;

public class PosParser
extends PerTileParser<PositionalData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.Position}));
    private final IlluminaFileUtil.SupportedIlluminaFormat fileType;

    public PosParser(IlluminaFileMap tilesToFiles, IlluminaFileUtil.SupportedIlluminaFormat fileType) {
        super(tilesToFiles);
        this.fileType = fileType;
    }

    public PosParser(IlluminaFileMap tilesToFiles, int startingTile, IlluminaFileUtil.SupportedIlluminaFormat fileType) {
        super(tilesToFiles, startingTile);
        this.fileType = fileType;
    }

    @Override
    protected CloseableIterator<PositionalData> makeTileIterator(File file) {
        AbstractIlluminaPositionFileReader fileReader;
        switch (this.fileType) {
            case Pos: {
                fileReader = new PosFileReader(file);
                break;
            }
            case Locs: {
                fileReader = new LocsFileReader(file);
                break;
            }
            case Clocs: {
                fileReader = new ClocsFileReader(file);
                break;
            }
            default: {
                throw new PicardException("Unrecognized pos file type " + this.fileType.name());
            }
        }
        return new CloseableIterator<PositionalData>(){
            private AbstractIlluminaPositionFileReader reader;
            {
                this.reader = fileReader;
            }

            public void close() {
                this.reader.close();
            }

            public boolean hasNext() {
                return this.reader.hasNext();
            }

            public PositionalData next() {
                final AbstractIlluminaPositionFileReader.PositionInfo nextValue = this.reader.next();
                return new PositionalData(){

                    @Override
                    public int getXCoordinate() {
                        return nextValue.xQseqCoord;
                    }

                    @Override
                    public int getYCoordinate() {
                        return nextValue.yQseqCoord;
                    }

                    public int getLane() {
                        return nextValue.lane;
                    }

                    public int getTile() {
                        return nextValue.tile;
                    }
                };
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

