/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.util.SortingCollection;
import org.apache.log4j.Logger;
import org.broad.igv.tools.sort.SortableRecord;

public class SortableRecordCodec
implements SortingCollection.Codec<SortableRecord> {
    private static Logger log = Logger.getLogger(SortableRecordCodec.class);
    DataOutputStream outputStream;
    DataInputStream inputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = new DataInputStream(inputStream);
    }

    public void encode(SortableRecord record) {
        try {
            this.outputStream.writeUTF(record.getChromosome());
            this.outputStream.writeInt(record.getStart());
            String s = record.getText();
            byte[] textBytes = s.getBytes("utf-8");
            this.outputStream.writeInt(textBytes.length);
            this.outputStream.write(textBytes, 0, textBytes.length);
        }
        catch (IOException ex) {
            log.error((Object)"Error encoding alignment", (Throwable)ex);
        }
    }

    public SortableRecord decode() {
        try {
            String chr = this.inputStream.readUTF();
            int start = this.inputStream.readInt();
            int textLen = this.inputStream.readInt();
            byte[] textBytes = new byte[textLen];
            this.inputStream.readFully(textBytes);
            String text = new String(textBytes, "utf-8");
            return new SortableRecord(chr, start, text);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            log.error((Object)"Error decoding alignment", (Throwable)ex);
            return null;
        }
    }

    public SortingCollection.Codec<SortableRecord> clone() {
        SortableRecordCodec other = new SortableRecordCodec();
        return other;
    }
}

