/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.GeraldAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentParser;
import org.broad.igv.sam.reader.SolexaQualityConverter;
import org.broad.tribble.readers.AsciiLineReader;

public class GeraldParser
implements AlignmentParser {
    private static Logger log = Logger.getLogger(GeraldParser.class);
    private static final int READ_NAME_COLUMN = 7;
    private static final int PASSING_FILTER_COLUMN = 21;
    private static final int QUALITIES_COLUMN = 9;
    private static final int SINGLE_READ_ALIGNMENT_SCORE_COLUMN = 15;
    private static final int PAIRED_READ_ALIGNMENT_SCORE_COLUMN = 16;
    public static final int ALIGNMENT_START_COLUMN = 12;
    public static final int MATE_CHROMOSOME_COLUMN = 17;
    public static final int MATE_OFFSET_COLUMN = 19;
    public static final int READ_COLUMN = 8;
    public static final int READ_NUMBER = 7;
    public static final int CHROMOSOME_COLUMN = 10;
    private static final int MATE_STRAND_COLUMN = 20;
    private static final int READ_STRAND_COLUMN = 13;
    private static final int REQUIRED_EXPORT_COLUMNS = 22;
    SolexaQualityConverter solexaToPhredQualityConverter = SolexaQualityConverter.getSingleton();
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    Genome genome;
    static Map<String, String> seqChrMap;

    @Override
    public GeraldAlignment readNextRecord(AsciiLineReader reader) {
        String nextLine = null;
        try {
            nextLine = reader.readLine();
        }
        catch (IOException e) {
            log.error((Object)"Error reading line", (Throwable)e);
            return null;
        }
        if (nextLine == null) {
            return null;
        }
        return this.createGeraldAlignment(nextLine);
    }

    private GeraldAlignment createGeraldAlignment(String nextLine) {
        String[] fields = Globals.tabPattern.split(nextLine, -1);
        int nTokens = fields.length;
        StringBuffer readName = new StringBuffer(20);
        for (int c = 0; c < 7; ++c) {
            if (c > 0 && fields[c] != null && fields[c].length() > 0) {
                readName.append(':');
            }
            readName.append(fields[c]);
        }
        GeraldAlignment alignment = new GeraldAlignment(readName.toString());
        String readNumberString = fields[7];
        boolean isPaired = readNumberString != null && readNumberString.length() > 0 && nTokens > 18;
        String mappingQString = null;
        if (isPaired) {
            mappingQString = fields[16];
        }
        if (mappingQString == null || mappingQString.length() == 0) {
            mappingQString = fields[15];
        }
        if (mappingQString != null && mappingQString.length() > 0) {
            alignment.setMappingQuality(Integer.parseInt(mappingQString));
        } else {
            alignment.setMappingQuality(255);
        }
        String readChr = this.mapChromosome(fields[10]);
        int alignmentStart = Integer.parseInt(fields[12]) - 1;
        String strandString = fields[13];
        boolean isNegativeStrand = strandString.equals("R");
        alignment.setNegativeStrand(isNegativeStrand);
        String readString = fields[8];
        byte[] phredQualities = fields[9].getBytes();
        this.solexaToPhredQualityConverter.convertSolexa_1_3_QualityCharsToPhredBinary(phredQualities);
        if (isNegativeStrand) {
            readString = AlignmentUtils.reverseComplement(readString);
            GeraldParser.reverseArray(phredQualities);
        }
        byte[] read = readString.getBytes();
        alignment.setReads(readChr, alignmentStart, read, phredQualities);
        if (isPaired) {
            String mateChr = this.mapChromosome(fields[17]);
            int mateStart = -1;
            if (mateChr == null || mateChr.length() == 0) {
                mateChr = readChr;
                String mateOffsetString = fields[19].trim();
                if (mateOffsetString != null && mateOffsetString.length() > 0) {
                    int inferredInsertSize = Integer.parseInt(mateOffsetString);
                    alignment.setInferredInsertSize(inferredInsertSize);
                    mateStart = alignment.getStart() + inferredInsertSize;
                }
            }
            String mateStrandString = fields[20];
            boolean mateStrandIsNegative = mateStrandString.equals("R");
            alignment.setMate(new ReadMate(mateChr, mateStart, mateStrandIsNegative, true));
        }
        String passedFilterString = null;
        if (fields.length > 21) {
            passedFilterString = fields[21];
        }
        boolean passingFilter = passedFilterString == null || "Y".equals(passedFilterString);
        alignment.setPassedFilter(passingFilter);
        return alignment;
    }

    public String mapChromosome(String seq) {
        if (seqChrMap == null) {
            GeraldParser.loadChrMap();
        }
        String chr = seqChrMap.containsKey(seq) ? seqChrMap.get(seq) : seq;
        return this.genome == null ? chr : this.genome.getChromosomeAlias(chr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void loadChrMap() {
        seqChrMap = new HashMap<String, String>();
        File samDir = DirectoryManager.getSamDirectory();
        if (samDir.exists()) {
            File mapFile = new File(samDir, "sequence.map");
            if (!mapFile.exists()) {
                mapFile = new File(samDir, "sequence.map.txt");
            }
            if (mapFile.exists()) {
                BufferedReader br = null;
                try {
                    String nextLine;
                    br = new BufferedReader(new FileReader(mapFile));
                    while ((nextLine = br.readLine()) != null) {
                        String[] tokens = nextLine.split("\t");
                        if (tokens.length <= 1) continue;
                        seqChrMap.put(tokens[0], tokens[1]);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
    }

    public static void reverseArray(byte[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            byte temp = array[left];
            array[left] = array[right];
            array[right] = temp;
        }
    }
}

