/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.atm;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.atm.FileParameter;
import org.broad.igv.gs.atm.WebToolDescriptor;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.StringUtils;

public class ATMUtils {
    private static final Gson gson = new Gson();

    public static List<WebToolDescriptor> getWebTools() throws IOException {
        URL url = new URL(PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/descriptor");
        String contents = HttpUtils.getInstance().getContentsAsJSON(url);
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(contents).getAsJsonArray();
        List<WebToolDescriptor> webTools = ATMUtils.parseWebtools(array);
        return webTools;
    }

    public static WebToolDescriptor getWebTool(String name) throws IOException {
        name = name.replace(" ", "%20");
        URL url = new URL(PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/" + name + "/descriptor");
        String contents = HttpUtils.getInstance().getContentsAsJSON(url);
        JsonElement obj = new JsonParser().parse(contents);
        return ATMUtils.parseWebTool(obj);
    }

    private static List<WebToolDescriptor> parseWebtools(JsonArray webDescArray) {
        int count = webDescArray.size();
        ArrayList<WebToolDescriptor> webTools = new ArrayList<WebToolDescriptor>();
        for (int i = 0; i < count; ++i) {
            JsonElement obj = webDescArray.get(i);
            WebToolDescriptor webToolDescriptor = ATMUtils.parseWebTool(obj);
            webTools.add(webToolDescriptor);
        }
        return webTools;
    }

    private static WebToolDescriptor parseWebTool(JsonElement obj) {
        return (WebToolDescriptor)gson.fromJson(obj, WebToolDescriptor.class);
    }

    public static String getWebtoolLaunchURL(WebToolDescriptor descriptor) throws IOException {
        return ATMUtils.getWebtoolLaunchURL(descriptor, null);
    }

    public static String getWebtoolLaunchURL(WebToolDescriptor descriptor, String file) throws IOException {
        String name = descriptor.getName().replace(" ", "%20");
        String url = PreferenceManager.getInstance().get("GENOME_SPACE_ATM_SERVER") + "webtool/" + name + "/launchurl";
        List<FileParameter> fileParameters = descriptor.getFileParameters();
        if (file != null && fileParameters != null && fileParameters.size() > 0) {
            FileParameter param = fileParameters.get(0);
            url = url + "?" + param.getName() + "=" + StringUtils.encodeURL(file);
        }
        return HttpUtils.getInstance().getContentsAsString(new URL(url));
    }
}

