/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.tribble.Feature;

public class EncodePeakCodec
extends UCSCCodec {
    Genome genome;

    public EncodePeakCodec() {
        this((Genome)null);
    }

    public EncodePeakCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    public Feature decode(String nextLine) {
        int peakOffset;
        int strandChar;
        if (nextLine.trim().length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(nextLine);
        int tokenCount = tokens.length;
        if (tokenCount < 9) {
            return null;
        }
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getChromosomeAlias(c);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        EncodePeakFeature feature = new EncodePeakFeature(chr, start, end);
        feature.setName(tokens[3]);
        feature.setScore(Float.parseFloat(tokens[4]));
        String strandString = tokens[5].trim();
        int n = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        Strand strand = strandChar == 45 ? Strand.NEGATIVE : (strandChar == 43 ? Strand.POSITIVE : Strand.NONE);
        feature.setStrand(strand);
        StringBuffer desc = new StringBuffer();
        desc.append("Signal value: " + tokens[6]);
        desc.append("<br>P value: " + tokens[7]);
        desc.append("<br>Q value: " + tokens[8]);
        if (tokens.length > 9 && (peakOffset = Integer.parseInt(tokens[9])) >= 0) {
            int peakPosition = feature.getStart() + peakOffset;
            feature.setPeakPosition(peakPosition);
            desc.append("<br>Peak: " + (peakPosition + 1));
        }
        feature.setDescription(desc.toString());
        return feature;
    }

    public boolean canDecode(String s) {
        return s.toLowerCase().endsWith("peak");
    }
}

