/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.ObjectCache;

public class SequenceWrapper
implements Sequence {
    private static Logger log = Logger.getLogger(SequenceWrapper.class);
    private static boolean cacheSequences = true;
    private static int tileSize = 1000000;
    private Sequence sequence;
    private ObjectCache<String, SequenceTile> sequenceCache = new ObjectCache(50);
    private static Hashtable<String, String> sequenceUrlCache = new Hashtable();

    public SequenceWrapper(Sequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public byte getBase(String chr, int position) {
        if (cacheSequences) {
            int tileNo = position / tileSize;
            SequenceTile tile = this.getSequenceTile(chr, tileNo);
            int offset = position - tile.getStart();
            byte[] bytes = tile.bytes;
            if (offset > 0 && offset < bytes.length) {
                return bytes[offset];
            }
            return 0;
        }
        return this.sequence.getBase(chr, position);
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.sequence.getChromosomeNames();
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return this.sequence.getChromosomeLength(chrname);
    }

    @Override
    public byte[] getSequence(String chr, int start, int end) {
        if (cacheSequences) {
            byte[] seqbytes = new byte[end - start];
            int startTile = start / tileSize;
            int endTile = end / tileSize;
            SequenceTile tile = this.getSequenceTile(chr, startTile);
            if (tile == null) {
                return null;
            }
            byte[] tileBytes = tile.getBytes();
            if (tileBytes == null) {
                return null;
            }
            int fromOffset = start - tile.getStart();
            int toOffset = 0;
            if (fromOffset < 0) {
                toOffset = -fromOffset;
                fromOffset = 0;
            }
            int nBytes = Math.min(tileBytes.length - Math.abs(fromOffset), seqbytes.length - Math.abs(toOffset));
            System.arraycopy(tileBytes, fromOffset, seqbytes, toOffset, nBytes);
            for (int t = startTile + 1; t <= endTile && (tile = this.getSequenceTile(chr, t)) != null; ++t) {
                int nNext = Math.min(seqbytes.length - nBytes, tile.getSize());
                System.arraycopy(tile.getBytes(), 0, seqbytes, nBytes, nNext);
                nBytes += nNext;
            }
            return seqbytes;
        }
        return this.sequence.getSequence(chr, start, end);
    }

    private SequenceTile getSequenceTile(String chr, int tileNo) {
        String key = SequenceWrapper.getKey(chr, tileNo);
        SequenceTile tile = this.sequenceCache.get(key);
        if (tile == null) {
            int start = tileNo * tileSize;
            int end = start + tileSize;
            if (end <= start) {
                return null;
            }
            byte[] seq = this.sequence.getSequence(chr, start, end);
            tile = new SequenceTile(start, seq);
            this.sequenceCache.put(key, tile);
        }
        return tile;
    }

    static String getKey(String chr, int tileNo) {
        return chr + "/" + tileNo;
    }

    static void setTileSize(int aChunkSize) {
        tileSize = aChunkSize;
    }

    static void setCacheSequences(boolean aCacheSequences) {
        cacheSequences = aCacheSequences;
    }

    public void clearCache() {
        this.sequenceCache.clear();
    }

    public static String checkSequenceURL(String url) {
        String key = url;
        String convertedURL = sequenceUrlCache.get(key);
        if (convertedURL == null) {
            convertedURL = url;
            convertedURL = convertedURL.replace("broad.mit.edu", "broadinstitute.org");
            convertedURL = convertedURL.replace("http://www.broadinstitute.org/igv/SequenceServlet", "http://igvdata.broadinstitute.org/genomes/seq");
            if (!url.equals(convertedURL = convertedURL.replace("http://www.broadinstitute.org/igv/sequence", "http://igvdata.broadinstitute.org/genomes/seq"))) {
                log.info((Object)("Converting sequence URL: " + url + " -> " + convertedURL));
            }
            sequenceUrlCache.put(key, convertedURL);
        }
        return convertedURL;
    }

    static class SequenceTile {
        private int start;
        private byte[] bytes;

        SequenceTile(int start, byte[] bytes) {
            this.start = start;
            this.bytes = bytes;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.bytes == null ? 0 : this.bytes.length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

