/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.tribble.Feature;

public class GFFParser
implements FeatureParser {
    static Logger log = Logger.getLogger(GFFParser.class);
    private TrackProperties trackProperties = null;
    public static Set<String> geneParts = new HashSet<String>();

    @Override
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome) {
        return this.loadFeatures(reader, genome, new GFFCodec(genome));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome, GFFCodec codec) {
        String line = null;
        int lineNumber = 0;
        GFFFeatureSource.GFFCombiner combiner = new GFFFeatureSource.GFFCombiner();
        try {
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("#")) {
                    codec.readHeaderLine(line);
                    continue;
                }
                try {
                    BasicFeature f = codec.decode(line);
                    if (f == null) continue;
                    combiner.addFeature(f);
                }
                catch (Exception e) {
                    log.error((Object)("Error parsing: " + line), (Throwable)e);
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error reading GFF file", (Throwable)ex);
            if (line != null && lineNumber != 0) {
                throw new ParserException(ex.getMessage(), (Throwable)ex, lineNumber, line);
            }
            throw new RuntimeException(ex);
        }
        this.trackProperties = TrackLoader.getTrackProperties(codec.getHeader());
        List<Feature> iFeatures = combiner.combineFeatures();
        if (IGV.hasInstance()) {
            FeatureDB.addFeatures(iFeatures, genome);
        }
        return iFeatures;
    }

    public static void splitFileByType(String gffFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(gffFile));
        String ext = "." + gffFile.substring(gffFile.length() - 4);
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) continue;
            String[] tokens = Globals.tabPattern.split(nextLine.trim().replaceAll("\"", ""), -1);
            String type = tokens[2];
            if (SequenceOntology.geneParts.contains(type)) {
                type = "gene";
            }
            if (writers.containsKey(type)) continue;
            writers.put(type, new PrintWriter(new FileWriter(new File(outputDirectory, type + ext))));
        }
        br.close();
        br = new BufferedReader(new FileReader(gffFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            String[] tokens = Globals.tabPattern.split(nextLine.trim().replaceAll("\"", ""), -1);
            String type = tokens[2];
            if (SequenceOntology.geneParts.contains(type)) {
                type = "gene";
            }
            if ((currentWriter = (PrintWriter)writers.get(type)) != null) {
                currentWriter.println(nextLine);
                continue;
            }
            System.out.println("No writer for: " + type);
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("SpitFilesByType <gffFile> <outputDirectory>");
            return;
        }
        GFFParser.splitFileByType(args[0], args[1]);
    }

    static {
        geneParts.add("five_prime_UTR");
        geneParts.add("three_prime_UTR");
        geneParts.add("5'-utr");
        geneParts.add("3'-utr");
        geneParts.add("3'-UTR");
        geneParts.add("5'-UTR");
        geneParts.add("5utr");
        geneParts.add("3utr");
        geneParts.add("CDS");
        geneParts.add("cds");
        geneParts.add("exon");
        geneParts.add("coding_exon");
        geneParts.add("intron");
        geneParts.add("transcript");
        geneParts.add("processed_transcript");
        geneParts.add("mrna");
        geneParts.add("mRNA");
    }
}

