/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.RuntimeUtils;

public class DatasetSizeTest {
    static int nPoints = 100000;
    static int nSample = 1000;

    public static void main(String[] args) {
        int i;
        for (i = 0; i < 5; ++i) {
            DatasetSizeTest.testArrays();
        }
        for (i = 0; i < 5; ++i) {
            DatasetSizeTest.testLocusScores();
        }
    }

    static void testArrays() {
        System.gc();
        int[] starts = new int[nPoints];
        int[] ends = new int[nPoints];
        float[][] values = new float[nPoints][nSample];
        String[] probes = new String[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            starts[i] = i;
            ends[i] = i;
            for (int j = 0; j < nSample; ++j) {
                values[i][j] = i * j;
            }
            probes[i] = "probe" + i;
        }
        long mem = RuntimeUtils.getAvailableMemory();
        ends = null;
        starts = null;
        values = null;
        probes = null;
        System.gc();
        System.gc();
        long mem2 = RuntimeUtils.getAvailableMemory();
        System.out.println("Memory used = " + (mem2 - mem) / 1000000L);
    }

    static void testLocusScores() {
        System.gc();
        ArrayList<TestScore> scores = new ArrayList<TestScore>(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            for (int j = 0; j < nSample; ++j) {
                scores.add(new TestScore(i, "probe" + i, i, i));
            }
        }
        long mem = RuntimeUtils.getAvailableMemory();
        scores = null;
        System.gc();
        System.gc();
        long mem2 = RuntimeUtils.getAvailableMemory();
        System.out.println("Memory used = " + (mem2 - mem) / 1000000L);
    }

    static class TestScore
    implements LocusScore {
        int start;
        int end;
        float score;
        String name;

        TestScore(int end, String name, float score, int start) {
            this.end = end;
            this.name = name;
            this.score = score;
            this.start = start;
        }

        @Override
        public void setStart(int start) {
        }

        @Override
        public void setEnd(int end) {
        }

        @Override
        public float getScore() {
            return 0.0f;
        }

        public LocusScore copy() {
            return null;
        }

        @Override
        public String getValueString(double position, WindowFunction windowFunction) {
            return null;
        }

        public String getChr() {
            return null;
        }

        public int getStart() {
            return 0;
        }

        public int getEnd() {
            return 0;
        }
    }
}

