/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class DataUtils {
    public static int getIndexBefore(int[] values, int x) {
        return DataUtils.getIndexBefore(values, x, 0, values.length);
    }

    public static int getIndexBefore(int[] values, int x, int leftBound, int rightBound) {
        int idx = (leftBound + rightBound) / 2;
        if (idx == 0 || idx == values.length - 1) {
            return idx;
        }
        if (values[idx] == x) {
            return idx;
        }
        if (values[idx] < x) {
            if (values[idx + 1] >= x) {
                return idx;
            }
            leftBound = idx;
            return DataUtils.getIndexBefore(values, x, leftBound, rightBound);
        }
        if (values[idx - 1] <= x) {
            return idx - 1;
        }
        rightBound = idx;
        return DataUtils.getIndexBefore(values, x, leftBound, rightBound);
    }

    public static AsciiFileMetrics estimateFileMetrics(String textFile) {
        int estRowCount = 0;
        try {
            double lineCount;
            BufferedReader reader = null;
            File file = new File(textFile);
            reader = new BufferedReader(new FileReader(file));
            String nextLine = reader.readLine();
            double nChars = 0.0;
            for (lineCount = 0.0; (nextLine = reader.readLine()) != null && lineCount < 100.0; lineCount += 1.0) {
                nChars += (double)nextLine.length();
            }
            int columnCount = nextLine.split("\t").length;
            double charsPerLine = lineCount > 0.0 ? nChars / lineCount : 0.0;
            estRowCount = (int)((double)file.length() / charsPerLine);
            return new AsciiFileMetrics(estRowCount, columnCount, charsPerLine);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static int estimatePreprocessingTime(AsciiFileMetrics fileMetrics) {
        return 8 + (int)(0.0036 * (double)fileMetrics.getEstRowCount() * (double)fileMetrics.getColumnCount() / 100.0);
    }

    public static class AsciiFileMetrics {
        private int estRowCount;
        private int columnCount;
        private double estBytesPerLine;

        public AsciiFileMetrics(int estRowCount, int columnCount, double estBytesPerLine) {
            this.estRowCount = estRowCount;
            this.columnCount = columnCount;
            this.estBytesPerLine = estBytesPerLine;
        }

        public double getEstBytesPerLine() {
            return this.estBytesPerLine;
        }

        public int getEstRowCount() {
            return this.estRowCount;
        }

        public int getColumnCount() {
            return this.columnCount;
        }
    }
}

