/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianInputStream;

public class BigBedDataBlock {
    private static Logger log = Logger.getLogger(BigBedDataBlock.class);
    private long fileOffset;
    private long dataBlockSize;
    private boolean isLowToHigh;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] bedBuffer;
    private int remDataSize;
    private LittleEndianInputStream lbdis;
    private DataInputStream dis;
    private ArrayList<BedFeature> bedFeatureList;

    public BigBedDataBlock(SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.dataBlockSize];
        this.fileOffset = this.leafHitItem.getDataOffset();
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.bedBuffer = uncompressBufSize > 0 ? new CompressionUtils().decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            String error = String.format("Error reading Bed data for leaf item %d \n", new Object[0]);
            log.error((Object)error, (Throwable)ex);
            throw new RuntimeException(error, ex);
        }
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(this.bedBuffer));
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(this.bedBuffer));
        }
        this.remDataSize = this.bedBuffer.length;
    }

    public ArrayList<BedFeature> getBedData(RPChromosomeRegion selectionRegion, boolean contained) {
        block8: {
            int itemNumber = 0;
            int minItemSize = 13;
            this.bedFeatureList = new ArrayList();
            try {
                int index = 0;
                while (this.remDataSize >= minItemSize) {
                    String restOfFields;
                    int chromEnd;
                    int chromStart;
                    int chromID;
                    itemNumber = index + 1;
                    if (this.isLowToHigh) {
                        chromID = this.lbdis.readInt();
                        chromStart = this.lbdis.readInt();
                        chromEnd = this.lbdis.readInt();
                        restOfFields = this.lbdis.readString();
                    } else {
                        chromID = this.dis.readInt();
                        chromStart = this.dis.readInt();
                        chromEnd = this.dis.readInt();
                        restOfFields = this.readHighToLowString();
                    }
                    int leafHitValue = selectionRegion.compareRegions(chromID, chromStart, chromID, chromEnd);
                    if (leafHitValue == -2 || contained && leafHitValue == -1) {
                        this.remDataSize -= minItemSize + restOfFields.length();
                        break;
                    }
                    if (leafHitValue == 2 || contained && leafHitValue == 1) {
                        this.remDataSize -= minItemSize + restOfFields.length();
                    } else {
                        this.remDataSize -= minItemSize + restOfFields.length();
                        String chromosome = this.chromosomeMap.get(chromID);
                        BedFeature bbItem = new BedFeature(itemNumber, chromosome, chromStart, chromEnd, restOfFields);
                        this.bedFeatureList.add(bbItem);
                    }
                    ++index;
                }
            }
            catch (IOException ex) {
                log.error((Object)("Read error for Bed data item " + itemNumber), (Throwable)ex);
                if (itemNumber != 1) break block8;
                throw new RuntimeException("Read error for Bed data item " + itemNumber, ex);
            }
        }
        return this.bedFeatureList;
    }

    private String readHighToLowString() throws IOException {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b = (byte)this.dis.read()) != 0) {
            bis.write(b);
        }
        String restOfFields = new String(bis.toByteArray());
        return restOfFields;
    }

    public void print() {
        log.debug((Object)("BigBed data for " + this.bedFeatureList.size() + " items"));
        for (int index = 0; index <= this.bedFeatureList.size(); ++index) {
            this.bedFeatureList.get(index).print();
        }
    }
}

