/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;

public class ProgressBar
extends JPanel
implements PropertyChangeListener {
    private boolean isReady = false;
    private JProgressBar progressBar;
    private boolean closeOnCompletion = false;
    private Window progressParentWindow;
    private ProgressMonitor monitor;

    public ProgressBar(Window progressParentWindow, int minimumProgress, int maximumProgress, boolean closeOnCompletion, ProgressMonitor monitor) {
        this.progressParentWindow = progressParentWindow;
        this.closeOnCompletion = closeOnCompletion;
        this.monitor = monitor;
        this.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(minimumProgress, maximumProgress);
        this.progressBar.setIndeterminate(true);
        this.add(this.progressBar);
        this.setReady(true);
    }

    public void setIndeterminate(boolean value) {
        this.progressBar.setIndeterminate(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isReady()) {
            if ("PROGRESS_PROPERTY".equalsIgnoreCase(evt.getPropertyName())) {
                int value = (Integer)evt.getNewValue();
                int progress = value > this.progressBar.getMaximum() ? 100 : value;
                this.progressBar.setValue(progress);
                if (progress > 99 && this.closeOnCompletion) {
                    this.setReady(false);
                    this.progressParentWindow.setVisible(false);
                }
            }
        } else {
            Object source = evt.getSource();
            if (source instanceof ProgressMonitor) {
                ((ProgressMonitor)source).setReady(false);
            }
        }
    }

    private static ProgressDialog createProgressDialog(Frame dialogsParent, String title, ProgressMonitor monitor, boolean closeOnCompletion) {
        ProgressDialog progressDialog = null;
        if (dialogsParent == null) {
            progressDialog = new ProgressDialog();
            progressDialog.setSize(500, 25);
            UIUtilities.centerWindow(progressDialog);
        } else {
            progressDialog = new ProgressDialog(dialogsParent);
            progressDialog.setSize(500, 25);
            if (dialogsParent.isVisible()) {
                progressDialog.setLocationRelativeTo(dialogsParent);
            } else {
                UIUtilities.centerWindow(progressDialog);
            }
        }
        final ProgressBar bar = new ProgressBar(progressDialog, 0, 100, closeOnCompletion, monitor);
        bar.setSize(500, 25);
        bar.setPreferredSize(bar.getSize());
        progressDialog.setDefaultCloseOperation(2);
        progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                bar.setReady(false);
            }
        });
        progressDialog.setModal(false);
        progressDialog.setTitle(title);
        progressDialog.setProgressBar(bar);
        monitor.addPropertyChangeListener(bar);
        progressDialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        return progressDialog;
    }

    public static ProgressDialog showProgressDialog(Frame dialogsParent, String title, ProgressMonitor monitor, boolean closeOnCompletion) {
        ProgressDialog progressDialog = ProgressBar.createProgressDialog(dialogsParent, title, monitor, closeOnCompletion);
        progressDialog.pack();
        progressDialog.setVisible(true);
        progressDialog.toFront();
        return progressDialog;
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
        if (value > 99 && this.closeOnCompletion) {
            this.setReady(false);
            if (this.progressParentWindow != null) {
                this.progressParentWindow.setVisible(false);
            }
        }
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void reset() {
        this.progressBar.setValue(0);
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
        if (this.monitor != null) {
            this.monitor.setReady(ready);
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public static class ProgressDialog
    extends JDialog {
        private ProgressBar progressBar = null;

        public ProgressDialog() {
        }

        public ProgressDialog(Frame frame) {
            super(frame);
        }

        public ProgressBar getProgressBar() {
            return this.progressBar;
        }

        public void setProgressBar(ProgressBar progressBar) {
            if (this.progressBar != null) {
                throw new IllegalStateException("ProgressBar already set");
            }
            this.progressBar = progressBar;
            this.getContentPane().add(progressBar);
        }
    }
}

