/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;

public class MouseableRegion {
    private Shape region;
    private String text;
    private TrackCltn trackCltn;

    public MouseableRegion(Shape region, Track track) {
        this.region = region;
        this.text = track.getName().equals(track.getName()) ? track.getName() : "<html>" + track.getName() + "<br>" + track.getName();
        this.trackCltn = new SingleTrackRegion(track);
    }

    public MouseableRegion(Shape region, String name, String value) {
        this.region = region;
        this.text = (name.length() > 0 ? name + " = " : "") + value;
        this.trackCltn = new AttributePanelRegion(name, value);
    }

    public boolean containsPoint(double x, double y) {
        return this.region.contains(x, y);
    }

    public Rectangle getBounds() {
        return this.region.getBounds();
    }

    public String getText() {
        return this.text;
    }

    public Set<Track> getTracks() {
        return this.trackCltn.getTracks();
    }

    public String toString() {
        return this.region.toString();
    }

    class AttributePanelRegion
    implements TrackCltn {
        private String key;
        private String value;

        public AttributePanelRegion(String key, String value) {
            this.key = key.toUpperCase();
            this.value = value;
        }

        @Override
        public Set<Track> getTracks() {
            HashSet<Track> selectedTracks = new HashSet<Track>();
            for (Track track : IGV.getInstance().getAllTracks()) {
                String attributeValue = track.getAttributeValue(this.key);
                if (attributeValue == null || !attributeValue.equals(this.value)) continue;
                selectedTracks.add(track);
            }
            return selectedTracks;
        }

        @Override
        public boolean contains(Track t) {
            return this.getTracks().contains(t);
        }
    }

    class SingleTrackRegion
    implements TrackCltn {
        private Set<Track> tracks = new HashSet<Track>();

        public SingleTrackRegion(Track track) {
            this.tracks.add(track);
        }

        @Override
        public Set<Track> getTracks() {
            return this.tracks;
        }

        @Override
        public boolean contains(Track t) {
            return this.tracks.contains(t);
        }
    }

    static interface TrackCltn {
        public Set<Track> getTracks();

        public boolean contains(Track var1);
    }
}

