/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.Interval;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.TribbleIndexNotFoundException;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.ResourceLocator;

public class MutationFeatureSource
implements FeatureSource<Mutation> {
    String sample;
    MutationDataManager dataManager;

    public MutationFeatureSource(String sample, MutationDataManager dataManager) {
        this.sample = sample;
        this.dataManager = dataManager;
    }

    @Override
    public Iterator<Mutation> getFeatures(String chr, int start, int end) throws IOException {
        return this.dataManager.getFeatures(this.sample, chr, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return -1;
    }

    @Override
    public void setFeatureWindowSize(int size) {
    }

    public static class MutationDataManager {
        Interval currentInterval;
        Map<String, List<Mutation>> featureMap = Collections.synchronizedMap(new HashMap());
        TribbleFeatureSource tribbleFeatureSource;

        public MutationDataManager(ResourceLocator locator, Genome genome) throws IOException, TribbleIndexNotFoundException {
            this.tribbleFeatureSource = TribbleFeatureSource.getFeatureSource(locator, genome);
        }

        synchronized Iterator<Mutation> getFeatures(String trackKey, String chr, int start, int end) throws IOException {
            List<Mutation> featureList;
            if (this.currentInterval == null || !this.currentInterval.contains(chr, start, end)) {
                Iterator features = this.tribbleFeatureSource.getFeatures(chr, start, end);
                while (features.hasNext()) {
                    Mutation feat = (Mutation)features.next();
                    String thisKey = feat.getSampleId();
                    List<Mutation> keyFeatures = this.featureMap.get(thisKey);
                    if (keyFeatures == null) {
                        keyFeatures = new ArrayList<Mutation>();
                        this.featureMap.put(thisKey, keyFeatures);
                    }
                    keyFeatures.add(feat);
                    this.currentInterval = new Interval(chr, start, end);
                }
            }
            return (featureList = this.featureMap.get(trackKey)) == null ? Collections.EMPTY_LIST.iterator() : featureList.iterator();
        }
    }
}

