/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.motiffinder;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.dev.api.batch.Command;
import org.broad.igv.feature.CachingFeatureSource;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.tools.motiffinder.MotifFinderDialog;
import org.broad.igv.tools.motiffinder.MotifFinderSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.util.StringUtils;

public class MotifFinderPlugin
implements IGVPlugin,
Command {
    @Override
    public void init() {
        JMenuItem menuItem = new JMenuItem("Find Motif...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotifFinderDialog dialog = new MotifFinderDialog(IGV.getMainFrame());
                dialog.setVisible(true);
                MotifFinderPlugin.handleDialogResult(dialog);
            }
        });
        IGV.getInstance().addOtherToolMenu(menuItem);
    }

    static void handleDialogResult(MotifFinderDialog dialog) {
        String[] pattern = dialog.getInputPattern();
        if (pattern != null) {
            String[] posTrackName = dialog.getPosTrackName();
            String[] negTrackName = dialog.getNegTrackName();
            MotifFinderPlugin.addTracksForPatterns(pattern, posTrackName, negTrackName);
        }
    }

    static List<Track> addTracksForPatterns(String[] pattern, String[] posTrackNames, String[] negTrackNames) {
        List<Track> trackList = MotifFinderPlugin.generateTracksForPatterns(pattern, posTrackNames, negTrackNames);
        IGV.getInstance().addTracks(trackList, PanelName.FEATURE_PANEL);
        return trackList;
    }

    static List<Track> generateTracksForPatterns(String[] patterns, String[] posTrackNames, String[] negTrackNames) {
        Color[] colors = new Color[]{null, Color.RED};
        Strand[] strands = new Strand[]{Strand.POSITIVE, Strand.NEGATIVE};
        ArrayList<Track> trackList = new ArrayList<Track>(2 * posTrackNames.length);
        if (patterns != null) {
            for (int pi = 0; pi < patterns.length; ++pi) {
                String pattern = patterns[pi];
                String[] curTrackNames = new String[]{posTrackNames[pi], negTrackNames[pi]};
                for (int ci = 0; ci < curTrackNames.length; ++ci) {
                    String tName = curTrackNames[ci];
                    if (tName == null) continue;
                    MotifFinderSource src = new MotifFinderSource(pattern, strands[ci], GenomeManager.getInstance().getCurrentGenome());
                    CachingFeatureSource cachingSrc = new CachingFeatureSource(src);
                    FeatureTrack track = new FeatureTrack(tName, tName, (FeatureSource)cachingSrc);
                    if (colors[ci] != null) {
                        track.setColor(colors[ci]);
                    }
                    track.setDisplayMode(Track.DisplayMode.SQUISHED);
                    trackList.add(track);
                }
            }
        }
        return trackList;
    }

    @Override
    public String run(List<String> args) {
        String cmd = args.get(0);
        if (cmd.equalsIgnoreCase("find")) {
            String pattern = args.get(1);
            String[] patterns = new String[]{pattern};
            String shrtPattern = StringUtils.checkLength(pattern, 100);
            String[] posName = new String[]{shrtPattern + " Positive"};
            String[] negName = new String[]{shrtPattern + " Negative"};
            MotifFinderPlugin.addTracksForPatterns(patterns, posName, negName);
            return "OK";
        }
        return "ERROR: Unknown command " + cmd + " for plugin " + this.getClass().getName();
    }
}

