/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.tools.CavenerConsensusCalculator;

public class PFMExporter {
    private static final char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    private static final int numNuc = nucleotides.length;
    public static String header1;
    private static String delim;

    public static String createPFMText(AlignmentCounts counts, String chr, int start, int end) {
        CavenerConsensusCalculator consCalc = new CavenerConsensusCalculator();
        ArrayList<String> allTextList = new ArrayList<String>(2);
        char[] consensus = new char[end - start + 1];
        for (int loc = start; loc < end; ++loc) {
            consensus[loc - start] = consCalc.calculateConsensusBase(counts, loc);
            Object[] curLocCounts = new String[numNuc];
            for (int ii = 0; ii < numNuc; ++ii) {
                char c = nucleotides[ii];
                int negCount = counts.getNegCount(loc, (byte)c);
                int posCount = counts.getPosCount(loc, (byte)c);
                curLocCounts[ii] = String.format("%d", negCount + posCount);
            }
            String curLine = StringUtils.join((Object[])curLocCounts, (String)delim);
            allTextList.add(curLine);
        }
        String topLine = String.format("%s:%d-%d%s%s", chr, start + 1, end, delim, String.valueOf(consensus).toUpperCase());
        allTextList.add(0, header1);
        allTextList.add(0, topLine);
        return StringUtils.join(allTextList, (String)"\n");
    }

    static {
        delim = "\t";
        Object[] capNuc = new String[numNuc];
        for (int n = 0; n < capNuc.length; ++n) {
            capNuc[n] = String.valueOf(nucleotides[n]).toUpperCase();
        }
        header1 = StringUtils.join((Object[])capNuc, (String)delim);
    }
}

