/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.RendererFactory;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.ui.color.ColorUtilities;

public class SessionXmlAdapters {

    public static class DataTrackIDAdapter
    extends XmlAdapter<String, DataTrack> {
        public String marshal(DataTrack dataTrack) throws Exception {
            return dataTrack.getId();
        }

        public DataTrack unmarshal(String trackId) throws Exception {
            DataTrack dataTrack = (DataTrack)IGVSessionReader.getMatchingTrack(trackId, null);
            if (dataTrack == null) {
                dataTrack = new DataSourceTrack(null, trackId, null, null);
            }
            return dataTrack;
        }
    }

    public static class Genome
    extends XmlAdapter<String, org.broad.igv.feature.genome.Genome> {
        public String marshal(org.broad.igv.feature.genome.Genome v) throws Exception {
            return v.getId();
        }

        public org.broad.igv.feature.genome.Genome unmarshal(String v) throws Exception {
            org.broad.igv.feature.genome.Genome genome = GenomeManager.getInstance().getCurrentGenome();
            if (genome != null && !genome.getId().equals(v)) {
                throw new IllegalStateException("Must load the proper genome before unmarshalling");
            }
            return genome;
        }
    }

    public static class Height
    extends XmlAdapter<String, Integer> {
        public String marshal(Integer height) throws Exception {
            if (height > 0) {
                return "" + height;
            }
            return null;
        }

        public Integer unmarshal(String heightString) throws Exception {
            if (heightString != null) {
                return Integer.parseInt(heightString);
            }
            return null;
        }
    }

    public static class ContinuousColorScale
    extends XmlAdapter<String, org.broad.igv.renderer.ContinuousColorScale> {
        public String marshal(org.broad.igv.renderer.ContinuousColorScale colorScale) throws Exception {
            if (colorScale != null && !colorScale.isDefault()) {
                return colorScale.asString();
            }
            return null;
        }

        public org.broad.igv.renderer.ContinuousColorScale unmarshal(String colorScaleString) throws Exception {
            ColorScale cs;
            if (colorScaleString != null && (cs = ColorScaleFactory.getScaleFromString(colorScaleString)) instanceof org.broad.igv.renderer.ContinuousColorScale) {
                return (org.broad.igv.renderer.ContinuousColorScale)cs;
            }
            return null;
        }
    }

    public static class Renderer
    extends XmlAdapter<String, org.broad.igv.renderer.Renderer> {
        public String marshal(org.broad.igv.renderer.Renderer renderer) throws Exception {
            RendererFactory.RendererType type;
            if (renderer != null && (type = RendererFactory.getRenderType(renderer)) != null) {
                return type.name();
            }
            return null;
        }

        public org.broad.igv.renderer.Renderer unmarshal(String rendererType) throws Exception {
            Class rendererClass;
            if (rendererType != null && (rendererClass = RendererFactory.getRendererClass(rendererType)) != null) {
                return (org.broad.igv.renderer.Renderer)rendererClass.newInstance();
            }
            return null;
        }
    }

    public static class Color
    extends XmlAdapter<String, java.awt.Color> {
        public String marshal(java.awt.Color value) throws Exception {
            if (value != null) {
                return ColorUtilities.colorToString(value);
            }
            return null;
        }

        public java.awt.Color unmarshal(String colorString) throws Exception {
            if (colorString != null) {
                return ColorUtilities.stringToColor(colorString);
            }
            return null;
        }
    }
}

