/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.cbio.FilterGeneNetworkUI;
import org.broad.igv.gitools.Gitools;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListEditDialog;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;

public class GeneListManagerUI
extends JDialog {
    private static Logger log = Logger.getLogger(GeneListManagerUI.class);
    private static String ALL = "All";
    private static String DEFAULT_ACTION_TEXT = "View";
    private static final GeneListListener DEFAULT_ACTION_LISTENER = new GeneListListener(){

        @Override
        public void actionPerformed(JDialog dialog, GeneList geneList) {
            IGV.getInstance().setGeneList(geneList);
            dialog.setVisible(false);
            dialog.dispose();
        }
    };
    static String lastSelectedGroup;
    String selectedGroup;
    ListListModel listModel;
    GeneListModel geneListModel;
    Map<String, GeneList> geneLists;
    private String selectedList;
    GeneListManager manager = GeneListManager.getInstance();
    private static GeneListManagerUI instance;
    private GeneListListener listener;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel2;
    private JPanel panel1;
    private JPanel panel6;
    private JLabel label1;
    private JTextField searchBox;
    private JPanel panel10;
    private JSplitPane splitPane2;
    private JSplitPane splitPane1;
    private JPanel panel3;
    private JLabel label3;
    private JScrollPane scrollPane1;
    private JList groupJList;
    private JPanel panel7;
    private JButton importButton;
    private JButton exportButton;
    private JButton deleteGroupButton;
    private JPanel panel4;
    private JLabel listLabel;
    private JScrollPane scrollPane2;
    private JList glJList;
    private JPanel panel8;
    private JButton newList;
    private JButton copyListButton;
    private JButton editButton;
    private JButton deleteButton;
    private JPanel panel5;
    private JLabel label4;
    private JScrollPane scrollPane3;
    private JList lociJList;
    private JPanel panel9;
    private JPanel buttonBar;
    private JButton exportTDMButton;
    private JButton viewNetworkButton;
    private JButton actionButton;
    private JButton closeButton;

    public static GeneListManagerUI getInstance(Frame owner) {
        return GeneListManagerUI.getInstance(owner, DEFAULT_ACTION_TEXT, DEFAULT_ACTION_LISTENER);
    }

    public static GeneListManagerUI getInstance(Frame owner, String actionText, GeneListListener listener) {
        if (instance == null) {
            instance = new GeneListManagerUI(owner);
        }
        GeneListManagerUI.instance.actionButton.setText(actionText);
        GeneListManagerUI.instance.listener = listener;
        if (listener != DEFAULT_ACTION_LISTENER) {
            GeneListManagerUI.instance.viewNetworkButton.setVisible(false);
        }
        return instance;
    }

    private GeneListManagerUI(Frame owner) {
        super(owner);
        this.initComponents();
        this.initLists();
    }

    private void initLists() {
        this.geneLists = this.manager.getGeneLists();
        this.groupJList.setModel(new AbstractListModel(){
            ArrayList<String> groups = new ArrayList();
            {
                this.groups.add(ALL);
                this.groups.addAll(GeneListManagerUI.this.manager.getGroups());
            }

            @Override
            public int getSize() {
                return this.groups.size();
            }

            @Override
            public Object getElementAt(int i) {
                return this.groups.get(i);
            }
        });
        this.listModel = new ListListModel();
        this.glJList.setModel(this.listModel);
        this.geneListModel = new GeneListModel();
        this.lociJList.setModel(this.geneListModel);
        if (lastSelectedGroup != null) {
            this.groupJList.setSelectedValue(lastSelectedGroup, true);
        } else {
            this.groupJList.setSelectedIndex(0);
        }
        this.glJList.setSelectedIndex(0);
    }

    private void groupsValueChanged(ListSelectionEvent e) {
        lastSelectedGroup = this.selectedGroup = (String)this.groupJList.getSelectedValue();
        this.deleteGroupButton.setEnabled(!"My lists".equals(this.selectedGroup) && GeneListManager.DEFAULT_GENE_LISTS.contains(this.selectedGroup));
        this.updateListModel();
    }

    private void listsValueChanged(ListSelectionEvent e) {
        this.selectedList = (String)this.glJList.getSelectedValue();
        if (this.selectedList == null) {
            this.geneListModel.clear();
        } else {
            this.actionButton.setEnabled(true);
            GeneList gl = this.listModel.getGeneList(this.selectedList);
            this.geneListModel.setGeneList(gl);
            this.lociJList.setModel(this.geneListModel);
            this.lociJList.updateUI();
            this.editButton.setEnabled(gl.isEditable());
            this.deleteButton.setEnabled(gl.isEditable());
        }
    }

    private void listLabelMouseClicked(MouseEvent e) {
        this.listModel.sort();
        this.glJList.updateUI();
    }

    private void searchBoxKeyReleased(KeyEvent e) {
        this.updateListModel();
    }

    private void updateListModel() {
        this.listModel.filter();
        this.glJList.clearSelection();
        this.glJList.updateUI();
        this.lociJList.updateUI();
    }

    private void createUIComponents() {
        this.glJList = new JList(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                int index = this.locationToIndex(evt.getPoint());
                if (index >= 0) {
                    Object item = this.getModel().getElementAt(index);
                    GeneList gl = GeneListManagerUI.this.geneLists.get(item);
                    return gl.getDescription();
                }
                return null;
            }
        };
    }

    private void editButtonActionPerformed(ActionEvent e) {
        String selection = (String)this.glJList.getSelectedValue();
        if (selection != null) {
            GeneList geneList = this.geneLists.get(selection);
            GeneListEditDialog dlg = new GeneListEditDialog((Dialog)this, geneList);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                this.geneListModel.setGeneList(geneList);
                this.listModel.filter();
                this.glJList.updateUI();
                this.lociJList.updateUI();
            }
        }
    }

    private void newListActionPerformed(ActionEvent e) {
        GeneList geneList = new GeneList();
        GeneListEditDialog dlg = new GeneListEditDialog((Dialog)this, geneList);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            geneList.setGroup("My lists");
            this.manager.addGeneList(geneList);
            this.listModel.add(geneList);
            this.glJList.updateUI();
            this.glJList.setSelectedValue(geneList.getName(), true);
            this.groupJList.updateUI();
        }
    }

    private void copyListButtonActionPerformed(ActionEvent e) {
        String selection = (String)this.glJList.getSelectedValue();
        if (selection != null) {
            GeneList geneList = this.geneLists.get(selection);
            GeneList copiedList = geneList.copy();
            GeneListEditDialog dlg = new GeneListEditDialog((Dialog)this, copiedList);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                this.listModel.add(copiedList);
                this.glJList.updateUI();
                this.glJList.setSelectedValue(copiedList.getName(), true);
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent e) {
        String selection = (String)this.glJList.getSelectedValue();
        if (selection != null && MessageUtils.confirm("<html>Are you sure you want to delete list '" + selection + "' ?" + "<br>associated lists? &nbsp;<b>This action cannot be undone")) {
            boolean groupRemoved = this.manager.deleteList(selection);
            if (groupRemoved) {
                this.initLists();
            } else {
                this.geneLists.remove(selection);
                this.listModel.filter();
                this.glJList.updateUI();
                this.glJList.setSelectedIndex(0);
                this.lociJList.updateUI();
            }
        }
    }

    private void importButtonActionPerformed(ActionEvent e) {
        File gmtFile = FileDialogUtils.chooseFile("Import GMT File");
        if (gmtFile != null) {
            try {
                List<GeneList> loadedLists = this.manager.importFile(gmtFile);
                this.initLists();
                if (loadedLists.size() > 0) {
                    this.groupJList.setSelectedValue(loadedLists.get(0).getGroup(), true);
                    this.glJList.setSelectedValue(loadedLists.get(0).getName(), true);
                    this.groupJList.updateUI();
                    this.glJList.updateUI();
                }
            }
            catch (IOException e1) {
                log.error((Object)"Error updating genome property file", (Throwable)e1);
                MessageUtils.showMessage("Error importing .gmt file: " + e1.getMessage());
            }
        }
    }

    private void exportButtonActionPerformed(ActionEvent e) {
        File initFile;
        File userDir;
        File glFile;
        if (this.selectedGroup != null && (glFile = FileDialogUtils.chooseFile("Save gene lists", userDir = DirectoryManager.getUserDirectory(), initFile = new File(this.selectedGroup + ".gmt"), FileDialogUtils.SAVE)) != null) {
            try {
                this.manager.exportGMT(this.selectedGroup, glFile);
            }
            catch (Exception e1) {
                log.error((Object)"Error exporting gene lists", (Throwable)e1);
                MessageUtils.showMessage("Error exporting gene lists: " + e1.getMessage());
            }
        }
    }

    private void deleteGroupButtonActionPerformed(ActionEvent e) {
        if (this.selectedGroup != null && MessageUtils.confirm(this, "<html>Are you sure you want to delete group '" + this.selectedGroup + "' and all " + "<br>associated lists? &nbsp;<b>This action cannot be undone")) {
            this.manager.deleteGroup(this.selectedGroup);
            this.initLists();
        }
    }

    private void closeButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void actionButtonActionPerformed(ActionEvent e) {
        if (this.selectedList != null) {
            GeneList geneList = this.geneLists.get(this.selectedList);
            this.listener.actionPerformed(this, geneList);
        }
    }

    private void glJListMouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.actionButtonActionPerformed(null);
        }
    }

    private void retrieveNetworkButtonActionPerformed(ActionEvent e) {
        if (this.selectedList != null) {
            GeneList geneList = this.geneLists.get(this.selectedList);
            FilterGeneNetworkUI fgnUI = new FilterGeneNetworkUI(IGV.getMainFrame(), geneList);
            fgnUI.setVisible(true);
        }
    }

    private void exportTDMButtonActionPerformed_deleteme(ActionEvent e) {
        if (this.selectedList != null) {
            GeneList geneList = this.geneLists.get(this.selectedList);
            File file = FileDialogUtils.chooseFile("Export TDM file", null, FileDialogUtils.SAVE);
            if (file != null) {
                try {
                    Gitools.exportTDM(geneList.getLoci(), file);
                }
                catch (IOException exc) {
                    log.error((Object)"Error exporting TDM data", (Throwable)exc);
                    MessageUtils.showErrorMessage("Error exporting TDM data", exc);
                }
            }
        }
    }

    private void initComponents() {
        this.createUIComponents();
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel2 = new JPanel();
        this.panel1 = new JPanel();
        this.panel6 = new JPanel();
        this.label1 = new JLabel();
        this.searchBox = new JTextField();
        this.panel10 = new JPanel();
        this.splitPane2 = new JSplitPane();
        this.splitPane1 = new JSplitPane();
        this.panel3 = new JPanel();
        this.label3 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.groupJList = new JList();
        this.panel7 = new JPanel();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.deleteGroupButton = new JButton();
        this.panel4 = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.panel8 = new JPanel();
        this.newList = new JButton();
        this.copyListButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.panel5 = new JPanel();
        this.label4 = new JLabel();
        this.scrollPane3 = new JScrollPane();
        this.lociJList = new JList();
        this.panel9 = new JPanel();
        this.buttonBar = new JPanel();
        this.exportTDMButton = new JButton();
        this.viewNetworkButton = new JButton();
        this.actionButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EtchedBorder(0));
        this.contentPanel.setLayout(new BorderLayout());
        this.panel2.setBackground(new Color(204, 204, 204));
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.panel1.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.panel1.setBackground(new Color(204, 204, 204));
        this.panel1.setLayout(new BoxLayout(this.panel1, 0));
        this.panel6.setMinimumSize(new Dimension(0, 0));
        this.panel6.setPreferredSize(new Dimension(400, 0));
        this.panel6.setOpaque(false);
        this.panel6.setLayout(null);
        this.panel1.add(this.panel6);
        this.label1.setText("Search");
        this.label1.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.panel1.add(this.label1);
        this.searchBox.setBorder(new BevelBorder(1));
        this.searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GeneListManagerUI.this.searchBoxKeyReleased(e);
            }
        });
        this.panel1.add(this.searchBox);
        this.panel10.setPreferredSize(new Dimension(5, 0));
        this.panel10.setMinimumSize(new Dimension(5, 0));
        this.panel10.setOpaque(false);
        this.panel10.setLayout(null);
        this.panel1.add(this.panel10);
        this.panel2.add(this.panel1);
        this.contentPanel.add((Component)this.panel2, "North");
        this.splitPane2.setBorder(null);
        this.splitPane2.setDividerLocation(600);
        this.splitPane1.setBorder(null);
        this.splitPane1.setDividerLocation(270);
        this.panel3.setBorder(LineBorder.createBlackLineBorder());
        this.panel3.setLayout(new BorderLayout());
        this.label3.setText("Group");
        this.panel3.add((Component)this.label3, "North");
        this.scrollPane1.setPreferredSize(new Dimension(80, 140));
        this.groupJList.setModel(new AbstractListModel(){
            String[] values = new String[]{"All"};

            @Override
            public int getSize() {
                return this.values.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.values[i];
            }
        });
        this.groupJList.setSelectionMode(0);
        this.groupJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeneListManagerUI.this.groupsValueChanged(e);
            }
        });
        this.scrollPane1.setViewportView(this.groupJList);
        this.panel3.add((Component)this.scrollPane1, "Center");
        this.panel7.setLayout(new BoxLayout(this.panel7, 0));
        this.importButton.setIcon(null);
        this.importButton.setText("Import");
        this.importButton.setToolTipText("Import a .gmt file, .grp, or .bed file");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.importButtonActionPerformed(e);
            }
        });
        this.panel7.add(this.importButton);
        this.exportButton.setText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.exportButtonActionPerformed(e);
            }
        });
        this.panel7.add(this.exportButton);
        this.deleteGroupButton.setText("Delete");
        this.deleteGroupButton.setEnabled(false);
        this.deleteGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.deleteGroupButtonActionPerformed(e);
            }
        });
        this.panel7.add(this.deleteGroupButton);
        this.panel3.add((Component)this.panel7, "South");
        this.splitPane1.setLeftComponent(this.panel3);
        this.panel4.setBorder(LineBorder.createBlackLineBorder());
        this.panel4.setLayout(new BorderLayout());
        this.listLabel.setText("List");
        this.listLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GeneListManagerUI.this.listLabelMouseClicked(e);
            }
        });
        this.panel4.add((Component)this.listLabel, "First");
        this.glJList.setSelectionMode(0);
        this.glJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeneListManagerUI.this.listsValueChanged(e);
            }
        });
        this.glJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GeneListManagerUI.this.glJListMouseClicked(e);
            }
        });
        this.scrollPane2.setViewportView(this.glJList);
        this.panel4.add((Component)this.scrollPane2, "Center");
        this.panel8.setLayout(new BoxLayout(this.panel8, 0));
        this.newList.setIcon(null);
        this.newList.setText("New");
        this.newList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.newListActionPerformed(e);
            }
        });
        this.panel8.add(this.newList);
        this.copyListButton.setText("Copy");
        this.copyListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.copyListButtonActionPerformed(e);
            }
        });
        this.panel8.add(this.copyListButton);
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.editButtonActionPerformed(e);
            }
        });
        this.panel8.add(this.editButton);
        this.deleteButton.setIcon(null);
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.deleteButtonActionPerformed(e);
            }
        });
        this.panel8.add(this.deleteButton);
        this.panel4.add((Component)this.panel8, "Last");
        this.splitPane1.setRightComponent(this.panel4);
        this.splitPane2.setLeftComponent(this.splitPane1);
        this.panel5.setBorder(LineBorder.createBlackLineBorder());
        this.panel5.setLayout(new BorderLayout());
        this.label4.setText("Loci");
        this.panel5.add((Component)this.label4, "North");
        this.lociJList.setSelectionMode(0);
        this.lociJList.setSelectionBackground(Color.white);
        this.lociJList.setSelectionForeground(Color.black);
        this.lociJList.setFocusable(false);
        this.scrollPane3.setViewportView(this.lociJList);
        this.panel5.add((Component)this.scrollPane3, "Center");
        this.panel9.setLayout(new BoxLayout(this.panel9, 0));
        this.panel5.add((Component)this.panel9, "South");
        this.splitPane2.setRightComponent(this.panel5);
        this.contentPanel.add((Component)this.splitPane2, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(null);
        this.buttonBar.setLayout(new FlowLayout(2));
        this.exportTDMButton.setText("Export TDM");
        this.exportTDMButton.setVisible(false);
        this.exportTDMButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.exportTDMButtonActionPerformed_deleteme(e);
            }
        });
        this.buttonBar.add(this.exportTDMButton);
        this.viewNetworkButton.setText("Retrieve Network");
        this.viewNetworkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.retrieveNetworkButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.viewNetworkButton);
        this.actionButton.setText("View");
        this.actionButton.setEnabled(false);
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.actionButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.actionButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.this.closeButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.closeButton);
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(845, 580);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static interface GeneListListener {
        public void actionPerformed(JDialog var1, GeneList var2);
    }

    class GeneListModel
    extends AbstractListModel {
        List<String> genes = new ArrayList<String>();

        GeneListModel() {
        }

        void setGeneList(GeneList geneList) {
            this.genes = geneList == null ? new ArrayList<String>() : new ArrayList<String>(geneList.getLoci());
        }

        @Override
        public int getSize() {
            return this.genes.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.genes.get(i);
        }

        public void clear() {
            this.genes.clear();
        }
    }

    class ListListModel
    extends AbstractListModel {
        boolean sortAscending;
        ArrayList<String> filteredNames;

        ListListModel() {
            this.filteredNames = new ArrayList(GeneListManagerUI.this.geneLists.size());
            this.filter();
        }

        @Override
        public int getSize() {
            return this.filteredNames.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.filteredNames.get(i);
        }

        void sort() {
            Collections.sort(this.filteredNames, new Comparator<String>(){

                @Override
                public int compare(String s, String s1) {
                    return ListListModel.this.sortAscending ? s.compareTo(s1) : s1.compareTo(s);
                }
            });
            this.sortAscending = !this.sortAscending;
        }

        GeneList getGeneList(String listName) {
            return GeneListManagerUI.this.geneLists.get(listName);
        }

        void filter() {
            this.filteredNames.clear();
            for (Map.Entry<String, GeneList> entry : GeneListManagerUI.this.geneLists.entrySet()) {
                String name = entry.getKey();
                GeneList gl = entry.getValue();
                if (gl == null || gl == null || !this.isPassFilter(gl)) continue;
                this.filteredNames.add(name);
            }
        }

        boolean isPassFilter(GeneList geneList) {
            if (GeneListManagerUI.this.selectedGroup != null && !GeneListManagerUI.this.selectedGroup.equals(ALL) && !geneList.getGroup().equals(GeneListManagerUI.this.selectedGroup)) {
                return false;
            }
            String filterString = GeneListManagerUI.this.searchBox.getText();
            if (filterString != null && filterString.trim().length() > 0) {
                String tmp = filterString.trim().toLowerCase();
                if (geneList.getName().toLowerCase().contains(tmp)) {
                    return true;
                }
                for (String gene : geneList.getLoci()) {
                    if (!gene.toLowerCase().contains(tmp)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void add(GeneList geneList) {
            GeneListManagerUI.this.geneLists.put(geneList.getName(), geneList);
            if (this.isPassFilter(geneList)) {
                this.filteredNames.add(geneList.getName());
            }
        }
    }
}

