/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.io.IOException;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.track.WindowFunction;

public class EQTLFeature
extends AbstractFeature {
    private String snp;
    String chr;
    int position;
    private String geneId;
    private String geneName;
    private float tStat;
    private float pValue;
    private float qValue;

    public EQTLFeature(String snp, String chr, int position, String geneId, String geneName, float tStat, float pValue, float qValue) {
        this.snp = snp;
        this.chr = chr;
        this.position = position;
        this.geneId = geneId;
        this.geneName = geneName;
        this.tStat = tStat;
        this.pValue = pValue;
        this.qValue = qValue;
    }

    public byte[] encodeBinary() throws IOException {
        BufferedByteWriter writer = new BufferedByteWriter();
        writer.putNullTerminatedString(this.snp);
        writer.putNullTerminatedString(this.chr);
        writer.putInt(this.position);
        writer.putNullTerminatedString(this.geneId);
        writer.putNullTerminatedString(this.geneName);
        writer.putFloat(this.tStat);
        writer.putFloat(this.pValue);
        writer.putFloat(this.qValue);
        return writer.getBytes();
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.position;
    }

    @Override
    public int getEnd() {
        return this.position + 1;
    }

    public String getSnp() {
        return this.snp;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.snp);
        sb.append("<br>" + this.geneId);
        sb.append("<br>" + this.geneName);
        sb.append("<br>tStat = " + this.tStat);
        sb.append("<br>pValue = " + this.pValue);
        sb.append("<br>qValue = " + this.qValue);
        return sb.toString();
    }

    @Override
    public String getURL() {
        return null;
    }
}

