/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.genome.Sequence;

public class InMemorySequence
implements Sequence {
    private Map<String, byte[]> sequenceMap;

    public InMemorySequence(Map<String, byte[]> sequenceMap) {
        this.sequenceMap = sequenceMap;
    }

    public InMemorySequence(String chr, byte[] seq) {
        this.sequenceMap = new HashMap<String, byte[]>();
        this.sequenceMap.put(chr, seq);
    }

    @Override
    public byte[] getSequence(String chr, int qstart, int qend) {
        byte[] allBytes = this.sequenceMap.get(chr);
        if (allBytes == null) {
            return null;
        }
        int start = Math.max(0, qstart);
        int end = Math.min(allBytes.length, qend);
        int len = end - start;
        byte[] bytes = new byte[len];
        Arrays.fill(bytes, (byte)0);
        int s = Math.max(start, 0);
        System.arraycopy(allBytes, s, bytes, 0, len);
        return bytes;
    }

    @Override
    public byte getBase(String chr, int position) {
        byte[] seqBytes = this.sequenceMap.get(chr);
        if (seqBytes != null && position < seqBytes.length) {
            return seqBytes[position];
        }
        return 0;
    }

    @Override
    public List<String> getChromosomeNames() {
        return new ArrayList<String>(this.sequenceMap.keySet());
    }

    @Override
    public int getChromosomeLength(String chrname) {
        byte[] bytes = this.sequenceMap.get(chrname);
        return bytes == null ? 0 : bytes.length;
    }
}

