/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.exome;

import org.broad.tribble.Feature;

public class ExomeBlock
implements Feature {
    int idx;
    private int genomeStart;
    private int exomeStart;
    private int length;
    private int leftPixel;
    private int rightPixel;

    public ExomeBlock(int idx, int genomeStart, int xomeStart, int length) {
        this.idx = idx;
        this.genomeStart = genomeStart;
        this.exomeStart = xomeStart;
        this.length = length;
    }

    public void setScreenBounds(int leftPixel, int rightPixel) {
        this.leftPixel = leftPixel;
        this.rightPixel = rightPixel;
    }

    public int getLeftPixel() {
        return this.leftPixel;
    }

    public int getRightPixel() {
        return this.rightPixel;
    }

    public int getIdx() {
        return this.idx;
    }

    public int getGenomeStart() {
        return this.genomeStart;
    }

    public int getGenomeEnd() {
        return this.genomeStart + this.length;
    }

    public int getExomeStart() {
        return this.exomeStart;
    }

    public int getExomeEnd() {
        return this.exomeStart + this.length;
    }

    public void extend(int x) {
        if (x > this.genomeStart + this.length) {
            this.length = x - this.genomeStart;
        }
    }

    public int getLength() {
        return this.getGenomeEnd() - this.getGenomeStart();
    }

    public String toString() {
        return "Block " + this.idx + " [" + this.genomeStart + ", " + this.getGenomeEnd() + ", " + this.exomeStart + ", " + this.length + "]";
    }

    public String getChr() {
        return null;
    }

    public int getStart() {
        return this.genomeStart;
    }

    public int getEnd() {
        return this.genomeStart + this.length;
    }

    public int compareGenomePosition(double genomicPosition) {
        if (genomicPosition < (double)this.genomeStart) {
            return -1;
        }
        if (genomicPosition >= (double)(this.genomeStart + this.length)) {
            return 1;
        }
        return 0;
    }

    public int compareExomePosition(int exomePosition) {
        if (exomePosition < this.exomeStart) {
            return -1;
        }
        if (exomePosition >= this.exomeStart + this.length) {
            return 1;
        }
        return 0;
    }
}

