/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DBProfileEditor
extends JDialog {
    public static final String ENABLE_EDITOR_PROPERTY = "enableDBProfileEditor";
    private DBProfile profile = new DBProfile();
    private String profilePath = null;
    private Map<String, DBProfile.DBTable> allTableNames = new LinkedHashMap<String, DBProfile.DBTable>();
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel16;
    private JLabel label16;
    private JComboBox DBSubprotocol;
    private JPanel panel4;
    private JLabel label4;
    private JTextField DBName;
    private JPanel panel1;
    private JLabel label1;
    private JTextField DBHost;
    private JPanel panel6;
    private JLabel label6;
    private JTextField DBPath;
    private JPanel panel5;
    private JLabel label5;
    private JTextField port;
    private JPanel panel2;
    private JLabel label2;
    private JTextField username;
    private JPanel panel3;
    private JLabel label3;
    private JPasswordField password;
    private JCheckBox checkBox1;
    private JSeparator separator1;
    private JPanel panel15;
    private JLabel label15;
    private JTextField newTableNameField;
    private JButton addNewTableButton;
    private JSeparator separator2;
    private JPanel panel7;
    private JLabel label7;
    private JComboBox tableName;
    private JPanel panel8;
    private JLabel label8;
    private JComboBox dataType;
    private JPanel panel9;
    private JLabel label9;
    private JTextField chromField;
    private JPanel panel10;
    private JLabel label10;
    private JTextField posStartField;
    private JPanel panel13;
    private JLabel label13;
    private JTextField posEndField;
    private JPanel panel11;
    private JLabel label11;
    private JTextField startColField;
    private JPanel panel12;
    private JLabel label12;
    private JTextField endColField;
    private JPanel panel14;
    private JLabel label14;
    private JTextField binColField;
    private JPanel buttonBar;
    private JButton saveButton;
    private JButton okButton;
    private JButton cancelButton;
    private JComponent[] tableFields;

    public DBProfileEditor(Frame owner, String initProfilePath) {
        super(owner);
        this.initComponents();
        this.postInit(initProfilePath);
    }

    public DBProfileEditor(Dialog owner, String initProfilePath) {
        super(owner);
        this.initComponents();
        this.postInit(initProfilePath);
    }

    private void postInit(String initProfilePath) {
        this.tableFields = new JComponent[]{this.chromField, this.posStartField, this.posEndField, this.startColField, this.endColField, this.binColField, this.dataType};
        assert (initProfilePath != null);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(CodecFactory.validExtensions.toArray(new String[0]));
        this.dataType.setModel(model);
        this.profilePath = initProfilePath;
        DBProfile.DBTable initTable = null;
        File initProfileFile = new File(initProfilePath);
        if (initProfileFile.exists()) {
            this.profile = DBProfile.parseProfile(initProfilePath);
            this.DBSubprotocol.setSelectedItem(this.profile.getSubprotocol());
            this.DBName.setText(this.profile.getName());
            this.DBHost.setText(this.profile.getHost());
            this.DBPath.setText(this.profile.getPath());
            this.port.setText(this.profile.getPort());
            this.username.setText(this.profile.getUsername());
            this.password.setText(this.profile.getPassword());
            this.initTableNameList();
            initTable = this.profile.getTableList().get(0);
        } else {
            this.profile = new DBProfile();
            this.profilePath = initProfilePath;
            if (!this.profilePath.endsWith(".dbxml")) {
                this.profilePath = this.profilePath + ".dbxml";
                initTable = null;
            }
        }
        this.populateTableFieldValues(initTable);
        this.attachTableFieldListeners();
    }

    private void initTableNameList() {
        List<DBProfile.DBTable> tableList = this.profile.getTableList();
        for (DBProfile.DBTable table : tableList) {
            this.allTableNames.put(table.getName(), table);
        }
        this.tableName.setModel(new VetoableComboBoxModel(this.allTableNames.keySet().toArray(new String[tableList.size()])));
    }

    private void saveDBInputs() {
        this.profile.setSubprotocol(this.DBSubprotocol.getSelectedItem().toString());
        this.profile.setName(this.DBName.getText());
        this.profile.setHost(this.DBHost.getText());
        this.profile.setPath(this.DBPath.getText());
        this.profile.setPort(this.port.getText());
        this.profile.setUsername(this.username.getText());
        char[] cpw = this.password.getPassword();
        if (cpw != null && cpw.length > 0) {
            String spw = new String(cpw);
            this.profile.setPassword(spw);
            spw = null;
            Arrays.fill(cpw, '\u0000');
        }
    }

    private DBProfile.DBTable getSelectedTable() {
        String selectedTableName = (String)this.tableName.getSelectedItem();
        return this.allTableNames.get(selectedTableName);
    }

    private boolean saveTableInput(DBProfile.DBTable table) {
        if (table == null) {
            return false;
        }
        int startColIndex = -1;
        int endColIndex = -1;
        try {
            startColIndex = Integer.parseInt(this.startColField.getText());
            endColIndex = Integer.parseInt(this.endColField.getText());
        }
        catch (NumberFormatException e) {
            MessageUtils.showErrorMessage("Entry must be a valid integer: " + e.getMessage(), e);
            return false;
        }
        table.setStartColIndex(startColIndex);
        table.setEndColIndex(endColIndex);
        table.setChromoColName(this.chromField.getText());
        table.setPosStartColName(this.posStartField.getText());
        table.setPosEndColName(this.posEndField.getText());
        table.setBinColName(this.binColField.getText());
        table.setFormat((String)this.dataType.getSelectedItem());
        return true;
    }

    private void attachTableFieldListeners() {
        FocusListener tableFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DBProfileEditor.this.saveTableInput(DBProfileEditor.this.getSelectedTable());
            }
        };
        for (JComponent tableField : this.tableFields) {
            tableField.addFocusListener(tableFocusListener);
        }
    }

    private void populateTableFieldValues(DBProfile.DBTable table) {
        boolean enabled = table != null;
        for (JComponent tableField : this.tableFields) {
            tableField.setEnabled(enabled);
        }
        if (table == null) {
            return;
        }
        this.chromField.setText(table.getChromoColName());
        this.posStartField.setText(table.getPosStartColName());
        this.posEndField.setText(table.getPosEndColName());
        this.startColField.setText("" + table.getStartColIndex());
        this.endColField.setText("" + table.getEndColIndex());
        this.binColField.setText(table.getBinColName());
        this.dataType.setSelectedItem(table.getFormat());
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void tableNameActionPerformed(ActionEvent e) {
        this.populateTableFieldValues(this.getSelectedTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent e) {
        this.saveDBInputs();
        if (!this.checkDBInputs()) {
            return;
        }
        OutputStreamWriter fileWriter = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setStrictErrorChecking(false);
            Marshaller m = DBProfile.getJAXBContext().createMarshaller();
            m.marshal((Object)this.profile, (Node)document);
            String xmlString = Utilities.getString(document);
            fileWriter = new FileWriter(this.profilePath);
            fileWriter.write(xmlString);
            this.setVisible(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private boolean checkDBInputs() {
        List<String> missingDBFields = this.profile.checkMissingValues();
        if (missingDBFields.size() > 0) {
            String msg = String.format("Please fill in all required database fields", new Object[0]);
            MessageUtils.showMessage(msg);
            return false;
        }
        List<DBProfile.DBTable> tables = this.profile.getTableList();
        if (tables.size() == 0) {
            MessageUtils.showMessage("You must add at least one table");
            return false;
        }
        for (DBProfile.DBTable table : tables) {
            if (this.checkTableAndWarn(table.getName())) continue;
            return false;
        }
        return true;
    }

    private void addNewTableButtonActionPerformed(ActionEvent e) {
        this.saveDBInputs();
        if (!this.checkTableAndWarn((String)this.tableName.getSelectedItem())) {
            return;
        }
        String strTableName = this.newTableNameField.getText();
        if (strTableName.length() == 0) {
            MessageUtils.showMessage("Please enter a table name");
            return;
        }
        DBProfile.DBTable newTable = new DBProfile.DBTable(this.profile.getDBLocator(), strTableName);
        this.profile.addTable(newTable);
        this.initTableNameList();
        this.tableName.setSelectedItem(strTableName);
        this.newTableNameField.setText("");
    }

    private boolean checkTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        DBProfile.DBTable table = this.allTableNames.get(tableName);
        List<String> missingFields = table.checkMissingValues();
        return missingFields.size() == 0;
    }

    private boolean checkTableAndWarn(String tableName) {
        if (!this.checkTable(tableName)) {
            MessageUtils.showMessage("Please fill in all required table fields in table " + tableName);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel16 = new JPanel();
        this.label16 = new JLabel();
        this.DBSubprotocol = new JComboBox();
        this.panel4 = new JPanel();
        this.label4 = new JLabel();
        this.DBName = new JTextField();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.DBHost = new JTextField();
        this.panel6 = new JPanel();
        this.label6 = new JLabel();
        this.DBPath = new JTextField();
        this.panel5 = new JPanel();
        this.label5 = new JLabel();
        this.port = new JTextField();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.username = new JTextField();
        this.panel3 = new JPanel();
        this.label3 = new JLabel();
        this.password = new JPasswordField();
        this.checkBox1 = new JCheckBox();
        this.separator1 = new JSeparator();
        this.panel15 = new JPanel();
        this.label15 = new JLabel();
        this.newTableNameField = new JTextField();
        this.addNewTableButton = new JButton();
        this.separator2 = new JSeparator();
        this.panel7 = new JPanel();
        this.label7 = new JLabel();
        this.tableName = new JComboBox();
        this.panel8 = new JPanel();
        this.label8 = new JLabel();
        this.dataType = new JComboBox();
        this.panel9 = new JPanel();
        this.label9 = new JLabel();
        this.chromField = new JTextField();
        this.panel10 = new JPanel();
        this.label10 = new JLabel();
        this.posStartField = new JTextField();
        this.panel13 = new JPanel();
        this.label13 = new JLabel();
        this.posEndField = new JTextField();
        this.panel11 = new JPanel();
        this.label11 = new JLabel();
        this.startColField = new JTextField();
        this.panel12 = new JPanel();
        this.label12 = new JLabel();
        this.endColField = new JTextField();
        this.panel14 = new JPanel();
        this.label14 = new JLabel();
        this.binColField = new JTextField();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(367, 550));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.panel16.setLayout(new BoxLayout(this.panel16, 0));
        this.label16.setText("Subprotocol:");
        this.label16.setHorizontalAlignment(2);
        this.label16.setMaximumSize(new Dimension(80, 16));
        this.panel16.add(this.label16);
        this.DBSubprotocol.setMaximumSize(new Dimension(250, 28));
        this.DBSubprotocol.setPreferredSize(new Dimension(250, 28));
        this.DBSubprotocol.setModel(new DefaultComboBoxModel<String>(new String[]{"mysql", "sqlite"}));
        this.DBSubprotocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBProfileEditor.this.tableNameActionPerformed(e);
            }
        });
        this.panel16.add(this.DBSubprotocol);
        this.contentPanel.add(this.panel16);
        this.panel4.setMaximumSize(new Dimension(330, 28));
        this.panel4.setLayout(new BoxLayout(this.panel4, 0));
        this.label4.setText("Name:");
        this.label4.setHorizontalAlignment(2);
        this.label4.setMaximumSize(new Dimension(80, 16));
        this.panel4.add(this.label4);
        this.DBName.setEditable(true);
        this.panel4.add(this.DBName);
        this.contentPanel.add(this.panel4);
        this.panel1.setLayout(new BoxLayout(this.panel1, 0));
        this.label1.setText("Host:");
        this.label1.setHorizontalAlignment(2);
        this.label1.setMaximumSize(new Dimension(80, 16));
        this.panel1.add(this.label1);
        this.DBHost.setMaximumSize(new Dimension(250, 28));
        this.DBHost.setPreferredSize(new Dimension(250, 28));
        this.DBHost.setToolTipText("my.awesomedb.com");
        this.panel1.add(this.DBHost);
        this.contentPanel.add(this.panel1);
        this.panel6.setLayout(new BoxLayout(this.panel6, 0));
        this.label6.setText("Path:");
        this.label6.setHorizontalAlignment(2);
        this.label6.setMaximumSize(new Dimension(80, 16));
        this.panel6.add(this.label6);
        this.DBPath.setMaximumSize(new Dimension(250, 28));
        this.DBPath.setPreferredSize(new Dimension(250, 28));
        this.DBPath.setToolTipText("myfolder");
        this.panel6.add(this.DBPath);
        this.contentPanel.add(this.panel6);
        this.panel5.setLayout(new BoxLayout(this.panel5, 0));
        this.label5.setText("Port (optional):");
        this.label5.setHorizontalAlignment(2);
        this.label5.setMaximumSize(new Dimension(80, 16));
        this.panel5.add(this.label5);
        this.port.setMaximumSize(new Dimension(250, 28));
        this.port.setPreferredSize(new Dimension(250, 28));
        this.port.setToolTipText("my.awesomedb.com");
        this.panel5.add(this.port);
        this.contentPanel.add(this.panel5);
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.label2.setText("Username:");
        this.label2.setHorizontalAlignment(2);
        this.label2.setMaximumSize(new Dimension(80, 16));
        this.label2.setMinimumSize(new Dimension(66, 16));
        this.label2.setPreferredSize(new Dimension(80, 16));
        this.panel2.add(this.label2);
        this.username.setMaximumSize(new Dimension(150, 28));
        this.username.setPreferredSize(new Dimension(150, 28));
        this.panel2.add(this.username);
        this.contentPanel.add(this.panel2);
        this.panel3.setMaximumSize(new Dimension(400, 28));
        this.panel3.setLayout(new BoxLayout(this.panel3, 0));
        this.label3.setText("Password (opt.):");
        this.label3.setMaximumSize(new Dimension(120, 16));
        this.label3.setMinimumSize(new Dimension(66, 16));
        this.label3.setPreferredSize(new Dimension(80, 16));
        this.label3.setHorizontalAlignment(2);
        this.panel3.add(this.label3);
        this.password.setMaximumSize(new Dimension(150, 28));
        this.password.setPreferredSize(new Dimension(150, 28));
        this.password.setEnabled(false);
        this.panel3.add(this.password);
        this.checkBox1.setText("Save");
        this.panel3.add(this.checkBox1);
        this.contentPanel.add(this.panel3);
        this.separator1.setPreferredSize(new Dimension(0, 1));
        this.contentPanel.add(this.separator1);
        this.panel15.setLayout(new BoxLayout(this.panel15, 0));
        this.label15.setText("New Table Name:");
        this.panel15.add(this.label15);
        this.newTableNameField.setToolTipText("Name for new table");
        this.newTableNameField.setMaximumSize(new Dimension(250, 28));
        this.panel15.add(this.newTableNameField);
        this.addNewTableButton.setText("Add");
        this.addNewTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBProfileEditor.this.addNewTableButtonActionPerformed(e);
            }
        });
        this.panel15.add(this.addNewTableButton);
        this.contentPanel.add(this.panel15);
        this.separator2.setPreferredSize(new Dimension(0, 1));
        this.contentPanel.add(this.separator2);
        this.panel7.setLayout(new BoxLayout(this.panel7, 0));
        this.label7.setText("Table Name:");
        this.label7.setHorizontalAlignment(2);
        this.label7.setMaximumSize(new Dimension(80, 16));
        this.panel7.add(this.label7);
        this.tableName.setMaximumSize(new Dimension(250, 28));
        this.tableName.setPreferredSize(new Dimension(250, 28));
        this.tableName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBProfileEditor.this.tableNameActionPerformed(e);
            }
        });
        this.panel7.add(this.tableName);
        this.contentPanel.add(this.panel7);
        this.panel8.setLayout(new BoxLayout(this.panel8, 0));
        this.label8.setText("Format:");
        this.label8.setHorizontalAlignment(2);
        this.label8.setMaximumSize(new Dimension(80, 16));
        this.panel8.add(this.label8);
        this.dataType.setMaximumSize(new Dimension(250, 28));
        this.dataType.setMinimumSize(new Dimension(96, 28));
        this.panel8.add(this.dataType);
        this.contentPanel.add(this.panel8);
        this.panel9.setLayout(new BoxLayout(this.panel9, 0));
        this.label9.setText("Chromosome Column Name:");
        this.label9.setHorizontalAlignment(2);
        this.label9.setMaximumSize(new Dimension(80, 16));
        this.panel9.add(this.label9);
        this.chromField.setMaximumSize(new Dimension(250, 28));
        this.chromField.setPreferredSize(new Dimension(250, 28));
        this.panel9.add(this.chromField);
        this.contentPanel.add(this.panel9);
        this.panel10.setLayout(new BoxLayout(this.panel10, 0));
        this.label10.setText("Position Start Column Name:");
        this.label10.setHorizontalAlignment(2);
        this.label10.setMaximumSize(new Dimension(80, 16));
        this.panel10.add(this.label10);
        this.posStartField.setMaximumSize(new Dimension(250, 28));
        this.posStartField.setPreferredSize(new Dimension(250, 28));
        this.panel10.add(this.posStartField);
        this.contentPanel.add(this.panel10);
        this.panel13.setLayout(new BoxLayout(this.panel13, 0));
        this.label13.setText("Position End Column Name:");
        this.label13.setHorizontalAlignment(2);
        this.label13.setMaximumSize(new Dimension(80, 16));
        this.panel13.add(this.label13);
        this.posEndField.setMaximumSize(new Dimension(250, 28));
        this.posEndField.setPreferredSize(new Dimension(250, 28));
        this.panel13.add(this.posEndField);
        this.contentPanel.add(this.panel13);
        this.panel11.setLayout(new BoxLayout(this.panel11, 0));
        this.label11.setText("Data start column index:");
        this.label11.setHorizontalAlignment(2);
        this.label11.setMaximumSize(new Dimension(80, 16));
        this.panel11.add(this.label11);
        this.startColField.setMaximumSize(new Dimension(250, 28));
        this.startColField.setPreferredSize(new Dimension(250, 28));
        this.startColField.setToolTipText("Starting column index from which to read data (1-based)");
        this.startColField.setText("1");
        this.panel11.add(this.startColField);
        this.contentPanel.add(this.panel11);
        this.panel12.setLayout(new BoxLayout(this.panel12, 0));
        this.label12.setText("Data end column index:");
        this.label12.setHorizontalAlignment(2);
        this.label12.setMaximumSize(new Dimension(80, 16));
        this.panel12.add(this.label12);
        this.endColField.setMaximumSize(new Dimension(250, 28));
        this.endColField.setPreferredSize(new Dimension(250, 28));
        this.endColField.setToolTipText("Last column (1-based, inclusive end) from which to read data");
        this.endColField.setText("2147483646");
        this.panel12.add(this.endColField);
        this.contentPanel.add(this.panel12);
        this.panel14.setLayout(new BoxLayout(this.panel14, 0));
        this.label14.setText("Bin column Name (opt.):");
        this.label14.setHorizontalAlignment(2);
        this.label14.setMaximumSize(new Dimension(80, 16));
        this.panel14.add(this.label14);
        this.binColField.setMaximumSize(new Dimension(250, 28));
        this.binColField.setPreferredSize(new Dimension(250, 28));
        this.binColField.setToolTipText("Some databases use binning to speed up querying");
        this.panel14.add(this.binColField);
        this.contentPanel.add(this.panel14);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText("Save Profile");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBProfileEditor.this.saveButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.okButton.setText("Load Data");
        this.okButton.setVisible(false);
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBProfileEditor.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class VetoableComboBoxModel
    extends DefaultComboBoxModel {
        private VetoableComboBoxModel(Object[] objects) {
            super(objects);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            Object oldItem = this.getSelectedItem();
            if (!DBProfileEditor.this.checkTableAndWarn((String)oldItem)) {
                return;
            }
            super.setSelectedItem(anItem);
        }
    }
}

