/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.LineIterator;

public abstract class CufflinksCodec<T extends Feature>
extends AsciiFeatureCodec<T> {
    private static Logger log = Logger.getLogger(CufflinksCodec.class);
    String path;

    protected CufflinksCodec(Class<T> clazz, String path) {
        super(clazz);
        this.path = path;
    }

    protected abstract Object readHeader(String[] var1);

    public Object readActualHeader(LineIterator reader) {
        String headerLine = null;
        try {
            headerLine = (String)reader.next();
            String[] tokens = ParsingUtils.TAB_PATTERN.split(headerLine);
            return this.readHeader(tokens);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new DataLoadException("Error reading header: " + e.getMessage(), this.path);
        }
    }
}

