/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineIterator;
import org.broad.tribble.readers.LineIteratorImpl;
import org.broad.tribble.readers.LineReader;

public class AsciiDecoder<D extends Feature>
implements FeatureDecoder<D> {
    private static Logger log = Logger.getLogger(AsciiDecoder.class);
    protected LineFeatureDecoder<D> lineFeatureDecoder;

    public AsciiDecoder() {
    }

    public AsciiDecoder(LineFeatureDecoder<D> lineFeatureDecoder) {
        this.lineFeatureDecoder = lineFeatureDecoder;
    }

    @Override
    public Iterator<D> decodeAll(InputStream is, boolean strictParsing) throws IOException {
        ArrayList<D> featuresList = new ArrayList<D>();
        LineIteratorImpl lrw = new LineIteratorImpl((LineReader)new AsciiLineReader(is));
        this.lineFeatureDecoder.readActualHeader((LineIterator)lrw);
        while (lrw.hasNext()) {
            String line = (String)lrw.next();
            try {
                D feat = this.decode(line);
                if (feat == null) continue;
                featuresList.add(feat);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (!strictParsing) continue;
                throw new RuntimeException(e);
            }
        }
        is.close();
        return featuresList.iterator();
    }

    public D decode(String line) {
        return this.lineFeatureDecoder.decode(line);
    }

    @Override
    public void setAttributes(List<Map<String, Object>> attributes) {
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
    }

    @Deprecated
    private static class QueuingLineReader
    implements LineIterator {
        private BufferedReader wrappedReader;
        private Queue<String> lineBuffer = new ArrayDeque<String>();
        private boolean queueing = false;
        private String next = null;
        private boolean iterating = false;

        QueuingLineReader(BufferedReader lineReader) {
            this.wrappedReader = lineReader;
        }

        void setQueueing(boolean queueing) {
            boolean wasQueuing = this.queueing;
            this.queueing = queueing;
            if (this.queueing) {
                this.lineBuffer.clear();
            } else {
                this.iterating = false;
                this.next = null;
            }
        }

        private String readLine() throws IOException {
            String line;
            if (this.queueing) {
                line = this.wrappedReader.readLine();
                if (line != null) {
                    this.lineBuffer.add(line);
                }
            } else {
                line = this.lineBuffer.poll();
                if (line == null) {
                    line = this.wrappedReader.readLine();
                }
            }
            return line;
        }

        public void close() {
            this.lineBuffer = null;
            try {
                this.wrappedReader.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        protected String advance() {
            String next = null;
            try {
                next = this.readLine();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return next;
        }

        public boolean hasNext() {
            if (!this.iterating) {
                this.next = this.advance();
                this.iterating = true;
            }
            return this.next != null;
        }

        public String peek() {
            return this.next;
        }

        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String ret = this.next;
            this.next = this.advance();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class DecoderWrapper<T extends Feature>
    extends AsciiDecoder<T>
    implements LineFeatureDecoder<T> {
        private AsciiFeatureCodec<T> wrappedCodec;

        public DecoderWrapper(AsciiFeatureCodec<T> wrappedCodec) {
            this.wrappedCodec = wrappedCodec;
            this.lineFeatureDecoder = this;
        }

        @Override
        public T decode(String line) {
            return (T)this.wrappedCodec.decode(line);
        }

        @Override
        public Object readActualHeader(LineIterator reader) throws IOException {
            return this.wrappedCodec.readHeader(reader);
        }
    }
}

